/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sim.kascpar.sc2ast;

import de.fzi.sim.kascpar.sc2ast.Node;
import de.fzi.sim.kascpar.sc2ast.SCParser;
import de.fzi.sim.kascpar.sc2ast.SCParserTreeConstants;
import de.fzi.sim.kascpar.sc2ast.SCParserVisitor;
import de.fzi.sim.kascpar.util.TokenInfo;
import org.w3c.dom.Element;

public class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected SCParser parser;
    protected String m_name;
    protected TokenInfo m_refInfo;
    protected long m_ASTInstanceId;
    static boolean m_elaborateComments = false;
    static boolean m_fileLineColumnSaving = false;

    public SimpleNode(int n) {
        this.id = n;
        this.m_name = null;
        this.m_refInfo = SCParser.getExtLineInfo(1);
        if (m_elaborateComments) {
            SCParser.addCommentToAST();
        }
        this.m_ASTInstanceId = SCParser.getNewASTInstanceID();
    }

    public SimpleNode(SCParser sCParser, int n) {
        this(n);
        this.parser = sCParser;
        this.m_name = null;
        this.m_refInfo = SCParser.getExtLineInfo(1);
        if (m_elaborateComments) {
            SCParser.addCommentToAST();
        }
        this.m_ASTInstanceId = SCParser.getNewASTInstanceID();
    }

    public void setName(String string) {
        this.m_name = string;
    }

    public String name() {
        return this.m_name;
    }

    public long getASTInstanceId() {
        return this.m_ASTInstanceId;
    }

    public String sourceFilePath() {
        if (this.m_refInfo != null) {
            return this.m_refInfo.refInfo().file();
        }
        return null;
    }

    public String sourceFile() {
        if (this.m_refInfo != null) {
            String string = this.m_refInfo.refInfo().file();
            int n = string.lastIndexOf("/");
            if (n == -1) {
                return string;
            }
            return string.substring(n + 1);
        }
        return null;
    }

    public int line() {
        if (this.m_refInfo != null) {
            return this.m_refInfo.refInfo().line() + 1;
        }
        return -1;
    }

    public void addSourceAndLineAttributesToElement(Element element) {
        if (!m_fileLineColumnSaving) {
            return;
        }
        if (element != null && this.sourceFile() != null) {
            element.setAttribute("file", this.sourceFile());
            element.setAttribute("line", Integer.toString(this.line()));
            element.setAttribute("column", Integer.toString(this.m_refInfo.column()));
        }
    }

    public void addNameAttributeToElement(Element element) {
        if (element != null && this.name() != null) {
            element.setAttribute("name", this.name());
        }
    }

    public void addASTInstanceIdToElement(Element element) {
        if (element != null) {
            element.setAttribute("idref", Long.toString(this.getASTInstanceId()));
        }
    }

    @Override
    public void jjtOpen() {
    }

    @Override
    public void jjtClose() {
    }

    @Override
    public void jjtSetParent(Node node) {
        this.parent = node;
    }

    @Override
    public Node jjtGetParent() {
        return this.parent;
    }

    @Override
    public void jjtAddChild(Node node, int n) {
        if (this.children == null) {
            this.children = new Node[n + 1];
        } else if (n >= this.children.length) {
            Node[] nodeArray = new Node[n + 1];
            System.arraycopy(this.children, 0, nodeArray, 0, this.children.length);
            this.children = nodeArray;
        }
        this.children[n] = node;
    }

    @Override
    public Node jjtGetChild(int n) {
        return this.children[n];
    }

    @Override
    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    @Override
    public Object jjtAccept(SCParserVisitor sCParserVisitor, Object object) {
        return sCParserVisitor.visit(this, object);
    }

    public Object childrenAccept(SCParserVisitor sCParserVisitor, Object object) {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i].jjtAccept(sCParserVisitor, object);
            }
        }
        return object;
    }

    public String toString() {
        return SCParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String string) {
        return string + this.toString();
    }

    public void dump(String string) {
        System.out.println(this.toString(string));
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode simpleNode = (SimpleNode)this.children[i];
                if (simpleNode == null) continue;
                simpleNode.dump(string + " ");
            }
        }
    }
}

