/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sim.kascpar.sc2ast;

import de.fzi.sim.kascpar.sc2ast.ASTtranslation_unit;
import de.fzi.sim.kascpar.sc2ast.ParseException;
import de.fzi.sim.kascpar.sc2ast.SCDumpVisitor;
import de.fzi.sim.kascpar.sc2ast.SCParser;
import de.fzi.sim.kascpar.sc2ast.XMLHelper;
import de.fzi.sim.kascpar.util.GCCPreprocessorCaller;
import de.fzi.sim.kascpar.util.LineMapper;
import de.fzi.sim.kascpar.util.ParamInf;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;

public class SC2AST {
    protected static final String FORMAT = "SC2AST [-help]\n       [-f source_file1 .. source_fileN]\n       [-i user_included_file]\n       [-o output_source_cpp_file]";
    protected static final String GCC_COMMAND_LINE = "g++ -E -C -w -H -nostdinc -nostdinc++ ";
    protected static final String LINE_MAPPING_REPORT_FILE = "line_mapping_report.txt";
    protected static final String DEF_OUTPUT_INTERNAL_XML = "result.cpp";
    protected static final String FILE_LIST_KEY = "-f";
    protected static final String RES_FILE_KEY = "-o";
    protected static final String user_included_file_KEY = "-i";
    protected static final String HELP_KEY = "-help";
    protected static final int DebugLevel = 0;
    protected static boolean m_processComments = true;
    protected static boolean m_saveFilelineColumn = true;

    public static void setCommentsProcessing(boolean bl) {
        m_processComments = bl;
    }

    public static void setFileLineColumnSaving(boolean bl) {
        m_saveFilelineColumn = bl;
    }

    public static boolean commentsProcessing() {
        return m_processComments;
    }

    public static boolean fileLineColumnSaving() {
        return m_saveFilelineColumn;
    }

    static int param_line_state(String string) {
        int n = string.equals(HELP_KEY) ? 1 : (string.equals(RES_FILE_KEY) ? 2 : (string.equals(FILE_LIST_KEY) ? 3 : (string.equals(user_included_file_KEY) ? 4 : 0)));
        return n;
    }

    static boolean getParams(String[] stringArray, ParamInf paramInf, ArrayList arrayList) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!(i != 0 || stringArray[0].equals(RES_FILE_KEY) || stringArray[0].equals(FILE_LIST_KEY) || stringArray[0].equals(HELP_KEY))) {
                System.err.println("ERROR: Incorrect format. Expected: \nSC2AST [-help]\n       [-f source_file1 .. source_fileN]\n       [-i user_included_file]\n       [-o output_source_cpp_file]");
                return false;
            }
            n = SC2AST.param_line_state(stringArray[i]);
            if (n == 1 && i == 0) {
                System.out.println("Usage: \nSC2AST [-help]\n       [-f source_file1 .. source_fileN]\n       [-i user_included_file]\n       [-o output_source_cpp_file]");
                return false;
            }
            if (n == 2 && !bl) {
                if (i + 1 >= stringArray.length) {
                    System.err.println("ERROR: Incorrect format. Can not find value of -o parameter. Expected: \nSC2AST [-help]\n       [-f source_file1 .. source_fileN]\n       [-i user_included_file]\n       [-o output_source_cpp_file]");
                    return false;
                }
                paramInf.m_file = stringArray[++i];
                bl = true;
                continue;
            }
            if (n == 3 && !bl2) {
                int n2;
                for (n2 = i + 1; n2 < stringArray.length; ++n2) {
                    if (SC2AST.param_line_state(stringArray[n2]) != 0) {
                        if (arrayList.size() != 0) break;
                        System.err.println("ERROR: Incorrect format. Can not find value(s) of -f parameter. Expected: \nSC2AST [-help]\n       [-f source_file1 .. source_fileN]\n       [-i user_included_file]\n       [-o output_source_cpp_file]");
                        return false;
                    }
                    arrayList.add(stringArray[n2]);
                }
                bl2 = true;
                i = n2 - 1;
                continue;
            }
            if (n != 4 || bl3) continue;
            bl3 = true;
            if (i + 1 >= stringArray.length) {
                System.err.println("ERROR: Incorrect format. Can not find value of -i parameter. Expected: \nSC2AST [-help]\n       [-f source_file1 .. source_fileN]\n       [-i user_included_file]\n       [-o output_source_cpp_file]");
                return false;
            }
            paramInf.m_user_included_file = stringArray[++i];
        }
        return true;
    }

    static String[] getSourceFiles(File file) {
        class SourceCFF
        implements FilenameFilter {
            protected String[] SRC_EXT = new String[]{".cpp", ".CPP", ".c", ".C"};

            SourceCFF() {
            }

            @Override
            public boolean accept(File file, String string) {
                for (int i = 0; i < this.SRC_EXT.length; ++i) {
                    int n = string.lastIndexOf(this.SRC_EXT[i]);
                    if (n == -1 || n + this.SRC_EXT[i].length() != string.length()) continue;
                    return true;
                }
                return false;
            }
        }
        return file.list(new SourceCFF());
    }

    static boolean elaborateParam(ParamInf paramInf, ArrayList arrayList) {
        Object object;
        File file = new File(System.getProperty("user.dir"));
        if (arrayList.size() == 0) {
            object = SC2AST.getSourceFiles(file);
            for (int i = 0; i < ((String[])object).length; ++i) {
                arrayList.add(object[i]);
            }
            if (arrayList.size() == 0) {
                System.out.println("WARNING: Can not find source files in " + file.getAbsolutePath() + " directory. Please check path to correct or specify source files by options '-f'.");
                return false;
            }
        } else {
            int n = 0;
            for (int i = 0; i < arrayList.size(); ++i) {
                File file2 = new File((String)arrayList.get(i));
                if (file2.exists() && file2.isFile()) continue;
                System.out.println("WARNING: Can not find file " + (String)arrayList.get(i - n));
                arrayList.remove(i - n);
                ++n;
            }
        }
        if (paramInf.m_user_included_file != null && !((File)(object = new File(paramInf.m_user_included_file))).exists()) {
            System.out.println("WARNING: Can not find user header file " + paramInf.m_user_included_file);
            paramInf.m_user_included_file = null;
        }
        return true;
    }

    static int getOSId() {
        String string = System.getProperty("os.name");
        string = string.toLowerCase();
        int n = -1;
        n = string.indexOf("linux") != -1 ? 0 : (string.indexOf("solaris") != -1 || string.indexOf("sunos") != -1 ? 1 : (string.indexOf("windows") != -1 ? 2 : -1));
        return n;
    }

    public static Document parse(ArrayList arrayList, String string, String string2, boolean bl) {
        return SC2AST.parse(arrayList, string, string2, false, null, bl);
    }

    public static Document parse(ArrayList arrayList, String string, String string2, String string3, boolean bl) {
        return SC2AST.parse(arrayList, string, string3, true, string2, bl);
    }

    protected static Document parse(ArrayList arrayList, String string, String string2, boolean bl, String string3, boolean bl2) {
        ParamInf paramInf = new ParamInf();
        paramInf.m_file = string;
        paramInf.m_com_source_file = null;
        paramInf.m_user_included_file = string2;
        int n = SC2AST.getOSId();
        if (n == -1) {
            System.err.println("Program can not work correctly under " + System.getProperty("os.name") + " OS");
            return null;
        }
        GCCPreprocessorCaller gCCPreprocessorCaller = new GCCPreprocessorCaller(GCC_COMMAND_LINE);
        if (!gCCPreprocessorCaller.execGCC(paramInf, arrayList, n)) {
            System.err.println("ERROR: Error encoutered during call of gcc preprocessor");
            return null;
        }
        File file = new File(paramInf.m_com_source_file);
        if (bl2) {
            System.out.print("Mapping lines  ...");
        }
        LineMapper lineMapper = new LineMapper();
        lineMapper.setOSId(n);
        lineMapper.setDebugLevel(0);
        lineMapper.setPreprocessorCmd(GCC_COMMAND_LINE);
        String string4 = null;
        if (!lineMapper.exec(gCCPreprocessorCaller.getErrorOutput(), file, string4)) {
            System.out.println("INFO: Line mapping failed!");
        } else if (lineMapper.lineMapping() && bl2) {
            System.out.println(" Ok!");
        }
        String string5 = file.getAbsolutePath();
        boolean bl3 = false;
        XMLHelper xMLHelper = null;
        try {
            if (bl2) {
                System.out.print("Parsing file " + string5 + " ...");
            }
            FileInputStream fileInputStream = new FileInputStream(string5);
            SCParser sCParser = new SCParser(fileInputStream);
            SCParser.setHasProcessMacroElab(0);
            SCParser.elaborateComments(SC2AST.commentsProcessing());
            SCParser.saveFileLineColumnInfoInAST(SC2AST.fileLineColumnSaving());
            SCParser.setLineMappingTable(lineMapper.lineMapping() ? lineMapper.lineDict() : null);
            ASTtranslation_unit aSTtranslation_unit = sCParser.translation_unit();
            if (aSTtranslation_unit == null) {
                System.err.println("Oops. Null reference has been returned from method SCParser::translation_unit ");
                return null;
            }
            if (bl2) {
                System.out.println(" OK!");
            }
            String string6 = string3;
            xMLHelper = new XMLHelper();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            xMLHelper.docInt = documentBuilder.newDocument();
            xMLHelper.mainInt = xMLHelper.docInt.createElement("INTERNAL");
            xMLHelper.xmlNodesInt = new ArrayList();
            xMLHelper.xmlNodesInt.add(xMLHelper.mainInt);
            xMLHelper.docInt.appendChild(xMLHelper.mainInt);
            SCDumpVisitor sCDumpVisitor = new SCDumpVisitor();
            aSTtranslation_unit.jjtAccept(sCDumpVisitor, xMLHelper);
            if (bl) {
                if (bl2) {
                    System.out.print("Saving AST information as XML file " + string6 + " ...");
                }
                OutputFormat outputFormat = new OutputFormat(xMLHelper.docInt, "UTF-8", true);
                outputFormat.setIndent(2);
                XMLSerializer xMLSerializer = new XMLSerializer(new FileWriter(string6), outputFormat);
                xMLSerializer.serialize(xMLHelper.docInt);
                if (bl2) {
                    System.out.println(" Ok!");
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("\nOops. " + fileNotFoundException.getMessage());
            fileNotFoundException.printStackTrace();
            bl3 = true;
        }
        catch (ParseException parseException) {
            System.err.println("\nOops. Error encoutered during parse.");
            if (lineMapper.lineMapping()) {
                System.err.println(SCParser.getErrorMessage());
            } else {
                System.err.println(parseException.getMessage());
                parseException.printStackTrace();
            }
            bl3 = true;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.err.println("\nOops. Error encoutered during creation of XML representation of AST.");
            System.err.println(parserConfigurationException.getMessage());
            parserConfigurationException.printStackTrace();
            bl3 = true;
        }
        catch (IOException iOException) {
            System.err.println("\nOops. Error encoutered during write AST modell into xml file.");
            System.err.println(iOException.getMessage());
            iOException.printStackTrace();
            bl3 = true;
        }
        catch (Exception exception) {
            System.err.println("\nOops. " + exception.getMessage());
            exception.printStackTrace();
            bl3 = true;
        }
        if (!bl3) {
            return xMLHelper.docInt;
        }
        return null;
    }

    public static void main(String[] stringArray) {
        ParamInf paramInf = new ParamInf();
        paramInf.m_file = DEF_OUTPUT_INTERNAL_XML;
        paramInf.m_com_source_file = null;
        paramInf.m_user_included_file = null;
        ArrayList arrayList = new ArrayList();
        if (!SC2AST.getParams(stringArray, paramInf, arrayList)) {
            System.exit(1);
            return;
        }
        if (!SC2AST.elaborateParam(paramInf, arrayList)) {
            System.err.println("ERROR: Can not elaborate command line parameters");
            System.exit(1);
            return;
        }
        SC2AST.setCommentsProcessing(true);
        SC2AST.setFileLineColumnSaving(true);
        if (SC2AST.parse(arrayList, paramInf.m_file, paramInf.m_file + ".ast.xml", paramInf.m_user_included_file, true) == null) {
            System.exit(1);
        } else {
            System.out.println("Programm finished successfully");
        }
    }
}

