/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sim.kascpar.sc2ast;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class JavaCharStream {
    public static final boolean staticFlag = true;
    public static int bufpos = -1;
    static int bufsize;
    static int available;
    static int tokenBegin;
    protected static int[] bufline;
    protected static int[] bufcolumn;
    protected static int column;
    protected static int line;
    protected static boolean prevCharIsCR;
    protected static boolean prevCharIsLF;
    protected static Reader inputStream;
    protected static char[] nextCharBuf;
    protected static char[] buffer;
    protected static int maxNextCharInd;
    protected static int nextCharInd;
    protected static int inBuf;
    protected static int tabSize;

    static final int hexval(char c) throws IOException {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        throw new IOException();
    }

    protected static void setTabSize(int n) {
        tabSize = n;
    }

    protected static int getTabSize(int n) {
        return tabSize;
    }

    protected static void ExpandBuff(boolean bl) {
        char[] cArray = new char[bufsize + 2048];
        int[] nArray = new int[bufsize + 2048];
        int[] nArray2 = new int[bufsize + 2048];
        try {
            if (bl) {
                System.arraycopy(buffer, tokenBegin, cArray, 0, bufsize - tokenBegin);
                System.arraycopy(buffer, 0, cArray, bufsize - tokenBegin, bufpos);
                buffer = cArray;
                System.arraycopy(bufline, tokenBegin, nArray, 0, bufsize - tokenBegin);
                System.arraycopy(bufline, 0, nArray, bufsize - tokenBegin, bufpos);
                bufline = nArray;
                System.arraycopy(bufcolumn, tokenBegin, nArray2, 0, bufsize - tokenBegin);
                System.arraycopy(bufcolumn, 0, nArray2, bufsize - tokenBegin, bufpos);
                bufcolumn = nArray2;
                bufpos += bufsize - tokenBegin;
            } else {
                System.arraycopy(buffer, tokenBegin, cArray, 0, bufsize - tokenBegin);
                buffer = cArray;
                System.arraycopy(bufline, tokenBegin, nArray, 0, bufsize - tokenBegin);
                bufline = nArray;
                System.arraycopy(bufcolumn, tokenBegin, nArray2, 0, bufsize - tokenBegin);
                bufcolumn = nArray2;
                bufpos -= tokenBegin;
            }
        }
        catch (Throwable throwable) {
            throw new Error(throwable.getMessage());
        }
        available = bufsize += 2048;
        tokenBegin = 0;
    }

    protected static void FillBuff() throws IOException {
        if (maxNextCharInd == 4096) {
            nextCharInd = 0;
            maxNextCharInd = 0;
        }
        try {
            int n = inputStream.read(nextCharBuf, maxNextCharInd, 4096 - maxNextCharInd);
            if (n == -1) {
                inputStream.close();
                throw new IOException();
            }
            maxNextCharInd += n;
            return;
        }
        catch (IOException iOException) {
            if (bufpos != 0) {
                --bufpos;
                JavaCharStream.backup(0);
            } else {
                JavaCharStream.bufline[JavaCharStream.bufpos] = line;
                JavaCharStream.bufcolumn[JavaCharStream.bufpos] = column;
            }
            throw iOException;
        }
    }

    protected static char ReadByte() throws IOException {
        if (++nextCharInd >= maxNextCharInd) {
            JavaCharStream.FillBuff();
        }
        return nextCharBuf[nextCharInd];
    }

    public static char BeginToken() throws IOException {
        if (inBuf > 0) {
            --inBuf;
            if (++bufpos == bufsize) {
                bufpos = 0;
            }
            tokenBegin = bufpos;
            return buffer[bufpos];
        }
        tokenBegin = 0;
        bufpos = -1;
        return JavaCharStream.readChar();
    }

    protected static void AdjustBuffSize() {
        if (available == bufsize) {
            if (tokenBegin > 2048) {
                bufpos = 0;
                available = tokenBegin;
            } else {
                JavaCharStream.ExpandBuff(false);
            }
        } else if (available > tokenBegin) {
            available = bufsize;
        } else if (tokenBegin - available < 2048) {
            JavaCharStream.ExpandBuff(true);
        } else {
            available = tokenBegin;
        }
    }

    protected static void UpdateLineColumn(char c) {
        ++column;
        if (prevCharIsLF) {
            prevCharIsLF = false;
            column = 1;
            ++line;
        } else if (prevCharIsCR) {
            prevCharIsCR = false;
            if (c == '\n') {
                prevCharIsLF = true;
            } else {
                column = 1;
                ++line;
            }
        }
        switch (c) {
            case '\r': {
                prevCharIsCR = true;
                break;
            }
            case '\n': {
                prevCharIsLF = true;
                break;
            }
            case '\t': {
                --column;
                column += tabSize - column % tabSize;
                break;
            }
        }
        JavaCharStream.bufline[JavaCharStream.bufpos] = line;
        JavaCharStream.bufcolumn[JavaCharStream.bufpos] = column;
    }

    public static char readChar() throws IOException {
        char c;
        if (inBuf > 0) {
            --inBuf;
            if (++bufpos == bufsize) {
                bufpos = 0;
            }
            return buffer[bufpos];
        }
        if (++bufpos == available) {
            JavaCharStream.AdjustBuffSize();
        }
        JavaCharStream.buffer[JavaCharStream.bufpos] = c = JavaCharStream.ReadByte();
        if (c == '\\') {
            JavaCharStream.UpdateLineColumn(c);
            int n = 1;
            while (true) {
                if (++bufpos == available) {
                    JavaCharStream.AdjustBuffSize();
                }
                try {
                    JavaCharStream.buffer[JavaCharStream.bufpos] = c = JavaCharStream.ReadByte();
                    if (c != '\\') {
                        JavaCharStream.UpdateLineColumn(c);
                        if (c == 'u' && (n & 1) == 1) {
                            if (--bufpos >= 0) break;
                            bufpos = bufsize - 1;
                            break;
                        }
                        JavaCharStream.backup(n);
                        return '\\';
                    }
                }
                catch (IOException iOException) {
                    if (n > 1) {
                        JavaCharStream.backup(n - 1);
                    }
                    return '\\';
                }
                JavaCharStream.UpdateLineColumn(c);
                ++n;
            }
            try {
                while ((c = JavaCharStream.ReadByte()) == 'u') {
                    ++column;
                }
                JavaCharStream.buffer[JavaCharStream.bufpos] = c = (char)(JavaCharStream.hexval(c) << 12 | JavaCharStream.hexval(JavaCharStream.ReadByte()) << 8 | JavaCharStream.hexval(JavaCharStream.ReadByte()) << 4 | JavaCharStream.hexval(JavaCharStream.ReadByte()));
                column += 4;
            }
            catch (IOException iOException) {
                throw new Error("Invalid escape character at line " + line + " column " + column + ".");
            }
            if (n == 1) {
                return c;
            }
            JavaCharStream.backup(n - 1);
            return '\\';
        }
        JavaCharStream.UpdateLineColumn(c);
        return c;
    }

    @Deprecated
    public static int getColumn() {
        return bufcolumn[bufpos];
    }

    @Deprecated
    public static int getLine() {
        return bufline[bufpos];
    }

    public static int getEndColumn() {
        return bufcolumn[bufpos];
    }

    public static int getEndLine() {
        return bufline[bufpos];
    }

    public static int getBeginColumn() {
        return bufcolumn[tokenBegin];
    }

    public static int getBeginLine() {
        return bufline[tokenBegin];
    }

    public static void backup(int n) {
        inBuf += n;
        if ((bufpos -= n) < 0) {
            bufpos += bufsize;
        }
    }

    public JavaCharStream(Reader reader, int n, int n2, int n3) {
        if (inputStream != null) {
            throw new Error("\n   ERROR: Second call to the constructor of a static JavaCharStream.\n       You must either use ReInit() or set the JavaCC option STATIC to false\n       during the generation of this class.");
        }
        inputStream = reader;
        line = n;
        column = n2 - 1;
        available = bufsize = n3;
        buffer = new char[n3];
        bufline = new int[n3];
        bufcolumn = new int[n3];
        nextCharBuf = new char[4096];
    }

    public JavaCharStream(Reader reader, int n, int n2) {
        this(reader, n, n2, 4096);
    }

    public JavaCharStream(Reader reader) {
        this(reader, 1, 1, 4096);
    }

    public void ReInit(Reader reader, int n, int n2, int n3) {
        inputStream = reader;
        line = n;
        column = n2 - 1;
        if (buffer == null || n3 != buffer.length) {
            available = bufsize = n3;
            buffer = new char[n3];
            bufline = new int[n3];
            bufcolumn = new int[n3];
            nextCharBuf = new char[4096];
        }
        prevCharIsCR = false;
        prevCharIsLF = false;
        maxNextCharInd = 0;
        inBuf = 0;
        tokenBegin = 0;
        bufpos = -1;
        nextCharInd = -1;
    }

    public void ReInit(Reader reader, int n, int n2) {
        this.ReInit(reader, n, n2, 4096);
    }

    public void ReInit(Reader reader) {
        this.ReInit(reader, 1, 1, 4096);
    }

    public JavaCharStream(InputStream inputStream, String string, int n, int n2, int n3) throws UnsupportedEncodingException {
        this(string == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string), n, n2, n3);
    }

    public JavaCharStream(InputStream inputStream, int n, int n2, int n3) {
        this(new InputStreamReader(inputStream), n, n2, 4096);
    }

    public JavaCharStream(InputStream inputStream, String string, int n, int n2) throws UnsupportedEncodingException {
        this(inputStream, string, n, n2, 4096);
    }

    public JavaCharStream(InputStream inputStream, int n, int n2) {
        this(inputStream, n, n2, 4096);
    }

    public JavaCharStream(InputStream inputStream, String string) throws UnsupportedEncodingException {
        this(inputStream, string, 1, 1, 4096);
    }

    public JavaCharStream(InputStream inputStream) {
        this(inputStream, 1, 1, 4096);
    }

    public void ReInit(InputStream inputStream, String string, int n, int n2, int n3) throws UnsupportedEncodingException {
        this.ReInit(string == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string), n, n2, n3);
    }

    public void ReInit(InputStream inputStream, int n, int n2, int n3) {
        this.ReInit(new InputStreamReader(inputStream), n, n2, n3);
    }

    public void ReInit(InputStream inputStream, String string, int n, int n2) throws UnsupportedEncodingException {
        this.ReInit(inputStream, string, n, n2, 4096);
    }

    public void ReInit(InputStream inputStream, int n, int n2) {
        this.ReInit(inputStream, n, n2, 4096);
    }

    public void ReInit(InputStream inputStream, String string) throws UnsupportedEncodingException {
        this.ReInit(inputStream, string, 1, 1, 4096);
    }

    public void ReInit(InputStream inputStream) {
        this.ReInit(inputStream, 1, 1, 4096);
    }

    public static String GetImage() {
        if (bufpos >= tokenBegin) {
            return new String(buffer, tokenBegin, bufpos - tokenBegin + 1);
        }
        return new String(buffer, tokenBegin, bufsize - tokenBegin) + new String(buffer, 0, bufpos + 1);
    }

    public static char[] GetSuffix(int n) {
        char[] cArray = new char[n];
        if (bufpos + 1 >= n) {
            System.arraycopy(buffer, bufpos - n + 1, cArray, 0, n);
        } else {
            System.arraycopy(buffer, bufsize - (n - bufpos - 1), cArray, 0, n - bufpos - 1);
            System.arraycopy(buffer, 0, cArray, n - bufpos - 1, bufpos + 1);
        }
        return cArray;
    }

    public static void Done() {
        nextCharBuf = null;
        buffer = null;
        bufline = null;
        bufcolumn = null;
    }

    public static void adjustBeginLineColumn(int n, int n2) {
        int n3;
        int n4 = tokenBegin;
        int n5 = bufpos >= tokenBegin ? bufpos - tokenBegin + inBuf + 1 : bufsize - tokenBegin + bufpos + 1 + inBuf;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        for (n3 = 0; n3 < n5 && bufline[n6 = n4 % bufsize] == bufline[n7 = ++n4 % bufsize]; ++n3) {
            JavaCharStream.bufline[n6] = n;
            n8 = n9 + bufcolumn[n7] - bufcolumn[n6];
            JavaCharStream.bufcolumn[n6] = n2 + n9;
            n9 = n8;
        }
        if (n3 < n5) {
            JavaCharStream.bufline[n6] = n++;
            JavaCharStream.bufcolumn[n6] = n2 + n9;
            while (n3++ < n5) {
                n6 = n4 % bufsize;
                if (bufline[n6] != bufline[++n4 % bufsize]) {
                    JavaCharStream.bufline[n6] = n++;
                    continue;
                }
                JavaCharStream.bufline[n6] = n;
            }
        }
        line = bufline[n6];
        column = bufcolumn[n6];
    }

    static {
        column = 0;
        line = 1;
        prevCharIsCR = false;
        prevCharIsLF = false;
        maxNextCharInd = 0;
        nextCharInd = -1;
        inBuf = 0;
        tabSize = 8;
    }
}

