// Number of generated inputes, change the command array when changing this value
#define INPUTSIZE 2
// size of the data we want to send
#define INTSIZE 32

// enables some extra outputs, set to 0 for disabling
#define DEBUG 0

#include "systemc.h"

//using namespace sc_core;
//using namespace sc_dt;
//using namespace std;

struct data
{
	//seems as if this has to be data, errors if not
	typedef data tlm_payload_type;
	//unused in our case but still necessary
	typedef int tlm_phase_type;

	//containing the submitted value
	int val;

	//dummy methods for being able to compile
	bool has_mm() { return false; }
	void set_mm(bool mm) { return; }
	void set_auto_extension(void* x) { return; }
	//these seem to be used for a kind of pooling for payloads
	//we don't use it here
	void acquire() { return; }
	void release() { return; }
	int get_ref_count() { return 1; }
	
};

#include "tlm.h"
#include "tlm_h/tlm_sockets/tlm_initiator_socket.h"
#include "tlm_h/tlm_sockets/tlm_target_socket.h"

//Module generating several read/write accesses to the memory
struct Producer : sc_module, tlm::tlm_bw_transport_if<data>
{

	//for using own datatypes we have to instantiate the initiator_socket with a Module, the size of the datatype we want to send over the socket, and the datatype we want to send.
  	tlm::tlm_initiator_socket< INTSIZE, data, 1 > socket;
	
	data d;

  	SC_CTOR(Producer)
  	: socket("socket")  // Construct and name socket
  	{
    	SC_THREAD(thread_process);
		//binding the interface (in our case implemented by the Producer itself) to the socket
		socket.bind(*this);
  	}

  //  void test();
  void thread_process();

   

	//interface methods needed for tlm_bw_transport_if
	//dummy implementation, as we only want b_transport and therefore only need the tlm_fw_transport_if at the consumer
	//we just have to implement this interface as initiator and targetsocket both have to implement matching interfaces.
	virtual void invalidate_direct_mem_ptr(sc_dt::uint64 start_range, sc_dt::uint64 end_range) {}
	tlm::tlm_sync_enum nb_transport_bw(data& tran, int& phase, sc_core::sc_time& t)
  {
sc_time delay = sc_time(10, SC_NS);
    socket->b_transport( d, delay );
		return tlm::TLM_COMPLETED;
	} 
	
};

void Producer::thread_process()
  	{
	  sc_time delay = sc_time(10, SC_NS);

	  while(true)
	 for (int i = 0; i < INPUTSIZE; i=i+1)
	   {

	  	  delay = sc_time(10, SC_NS);
			cout << "[" << sc_time_stamp() << "]: " << "Writing data " << i << " to memory." << endl;

			d.val = i;
			if (DEBUG) cout << "[" << sc_time_stamp() << "]: " << "Starting communication." << endl;
			socket->b_transport( d, delay );  // Blocking transport call

			if (DEBUG) cout << "[" << sc_time_stamp() << "]: " << "Communication finished, begin waiting." << endl;

			// Realize the delay annotated onto the transport call
			//	wait(delay);

			cout << "[" << sc_time_stamp() << "]: " << "Finished iteration " << i << "." << endl;			
    	}
  	}



// Target module
struct Consumer : sc_module, tlm::tlm_fw_transport_if<data>
{

  	tlm::tlm_target_socket< INTSIZE, data, 1 > socket;

        data d;
  int ph;

	SC_CTOR(Consumer)
	: socket("socket")
	{
		//binding the interface (in our case implemented by the Consumer itself) to the socket
		socket.bind(*this);
	}

  	// TLM-2 blocking transport method
	// the work that should be done when a b_transport is called from an initiator
	virtual void b_transport( data& tran, sc_time& t )
  {
    ph = 0;
		cout << "[" << sc_time_stamp() << "]: " << "Receiving " << tran.val << "." << endl;
		d.val = tran.val;
		t += sc_time(5,SC_NS);
		wait(t);
		socket->nb_transport_bw(tran,ph,t);
		
	}

	//dummy implementation, not needed here
	tlm::tlm_sync_enum nb_transport_fw(data& tran, int& phase, sc_core::sc_time& t)
	{
		return tlm::TLM_COMPLETED;
	}

	virtual bool get_direct_mem_ptr(data& tran, tlm::tlm_dmi& dmi_data) { return false; }
	virtual unsigned int transport_dbg(data& tran) { return 0; }
};


int sc_main(int argc, char* argv[])
{
  	Producer prod("p");
	Consumer cons("c");

	prod.socket.bind( cons.socket);	
	
  	sc_start();
  	return 0;
}

