#include <systemc.h>
#define LOOPCNT 500

SC_MODULE(input){

  sc_out<bool> inTicks_vl;
  sc_out<bool> inTicks_vr;
  sc_out<bool> inTicks_hl;
  sc_out<bool> inTicks_hr; 
  // sc_out<bool> resetAll;

  
  void generate(){
//  ms 
      for(int i1 = 0; i1 < LOOPCNT; i1 = i1 + 1){
// alle 680 us flankenwechsel -> 200 km/h
	  wait(1131, SC_US); 
	  inTicks_vl.write(1);
	  inTicks_vr.write(1);
	  inTicks_hl.write(1);
	  inTicks_hr.write(1);
	  wait(1131, SC_US);
	  inTicks_vl.write(0);
	  inTicks_vr.write(0);
	  inTicks_hl.write(0);
	  inTicks_hr.write(0);	  
	}

      for(int i2 = 0; i2 < LOOPCNT; i2 = i2 + 1){
// alle 754 us flankenwechsel -> 180 km/h
	  wait(1220, SC_US); 
	  inTicks_vl.write(1);
	  inTicks_vr.write(1);
	  inTicks_hl.write(1);
	  inTicks_hr.write(1);
	  wait(1200, SC_US);
	  inTicks_vl.write(0);
	  inTicks_vr.write(0);
	  inTicks_hl.write(0);
	  inTicks_hr.write(0);	  
	}

// 3 ms auf Reaktion auf die blockierenden Raeder warten
      wait(3, SC_MS); 
  }

  SC_CTOR(input){
      SC_THREAD(generate);
  }
  

};


