#include "systemc.h"

#include "TickCounter.h"
#include "ABSASR.h"
#include "input.h"
#include "outputmon.h"

int sc_main (int argc, char* argv[]){

  // ticks from input generator
  sc_signal<bool> ch_inTicks_vl;    
  sc_signal<bool> ch_inTicks_vr;   
  sc_signal<bool> ch_inTicks_hl;    
  sc_signal<bool> ch_inTicks_hr;    
  
  // pressure to output monitor
  sc_fifo<int> d_vl; 
  sc_fifo<int> d_vr;
  sc_fifo<int> d_hl;
  sc_fifo<int> d_hr;
  
  // ticks from tick counter to ECU
  sc_fifo<int> ticks_vl; 
  sc_fifo<int> ticks_vr;
  sc_fifo<int> ticks_hl;
  sc_fifo<int> ticks_hr;  

  // instantiate modules and connect channels

  input inp("inputs");
  inp.inTicks_vl(ch_inTicks_vl);
  inp.inTicks_vr(ch_inTicks_vr);
  inp.inTicks_hl(ch_inTicks_hl);
  inp.inTicks_hr(ch_inTicks_hr);

  TickCounter vl("vl");
  vl.inTicks(ch_inTicks_vl);
  vl.outTicks(ticks_vl);
    
  TickCounter vr("vr");
  vr.inTicks(ch_inTicks_vr);
  vr.outTicks(ticks_vr);
         
  TickCounter hl("hl");
  hl.inTicks(ch_inTicks_hl);
  hl.outTicks(ticks_hl);
    
  TickCounter hr("hr");
  hr.inTicks(ch_inTicks_hr);
  hr.outTicks(ticks_hr);
    
  ABSASR ecu_absasr("absasr");
  ecu_absasr.bus_vl(ticks_vl);
  ecu_absasr.bus_vr(ticks_vr);
  ecu_absasr.bus_hl(ticks_hl);
  ecu_absasr.bus_hr(ticks_hr);
  ecu_absasr.pr_vl(d_vl);
  ecu_absasr.pr_vr(d_vr);
  ecu_absasr.pr_hl(d_hl);
  ecu_absasr.pr_hr(d_hr);

  outputmon outp("output_monitor");
  outp.p_vl(d_vl);
  outp.p_hl(d_hl);
  outp.p_vr(d_vr);
  outp.p_hr(d_hr);

  // run the simulation till sc_stop is encountered     
  sc_start(5,SC_SEC); 
 
  cout << "@" << sc_time_stamp() <<" Terminating simulation\n" << endl;

  // terminate simulation
  return 0; 

}
