package de.tub.pes.state.util;

import org.aspectj.lang.Signature;

public aspect TraceAspect {
	
	String depth = "";
	
    pointcut traceMethods(): execution(* *.*(..)) && !within(TraceAspect);
	
	before() : traceMethods() {

	    Signature sig = thisJoinPointStaticPart.getSignature();
	    System.out.println(depth + "TRACE: Entering " + sig.getDeclaringType().getName() + "." + sig.getName());
	    depth += " ";
	}
	
	after()  : traceMethods() {
	    Signature sig = thisJoinPointStaticPart.getSignature();
	    System.out.println(depth + "TRACE: Exiting " + sig.getDeclaringType().getName() + "." + sig.getName());
	    if(depth.length() > 0) depth = depth.substring(1);
	}
}

