#include <systemc.h>

class sc_clockx : sc_module
{
  public:
    sc_event edge;
    
  private:
    int period;
    
    SC_HAS_PROCESS(sc_clockx);
    
    void run(void) {
      int tmp = period/2;
      edge.notify(SC_ZERO_TIME);
        while(true) {
            wait(tmp, SC_NS);
	    edge.notify(SC_ZERO_TIME);
        }
    }
    
  public:     
    sc_clockx(sc_module_name name, int periodparam): sc_module(name)
    {
        SC_THREAD(run);
        period = periodparam;
    }
    
};
