/*
 * Decompiled with CFR 0.152.
 */
package de.tub.pes.state.test;

import de.tub.pes.state.engine.Engine;
import de.tub.pes.state.util.TestUtils;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import junit.framework.TestCase;
import org.junit.Before;
import org.junit.Test;

public class TLMTest
extends TestCase {
    Engine eng;

    @Before
    public void setUp() {
        this.eng = new Engine();
    }

    @Test
    public void testSimpleNBTransport() throws IOException {
        String pathSource = "example/tlm/nb_transport/prodcons_ast.ast.xml";
        String pathTarget = "example/tlm/nb_transport/prodcons.uppaal.xml";
        File f = new File(pathTarget);
        if (f.exists()) {
            f.delete();
        }
        String[] args = new String[]{"-i", pathSource, "-o", pathTarget};
        Engine.main(args);
        f = new File(pathTarget);
        TLMTest.assertTrue((String)("File " + pathTarget + " has not been created."), (boolean)f.exists());
        char[] content = new char[(int)f.length()];
        FileReader fr = new FileReader(f);
        fr.read(content);
        TestUtils.checkSyntax(pathTarget);
    }

    @Test
    public void testSimpleBTransport() throws IOException {
        String pathSource = "example/tlm/b_transport/prodcons_ast.ast.xml";
        String pathTarget = "example/tlm/b_transport/prodcons.uppaal.xml";
        File f = new File(pathTarget);
        if (f.exists()) {
            f.delete();
        }
        String[] args = new String[]{"-i", pathSource, "-o", pathTarget};
        Engine.main(args);
        f = new File(pathTarget);
        TLMTest.assertTrue((String)("File " + pathTarget + " has not been created."), (boolean)f.exists());
        char[] content = new char[(int)f.length()];
        FileReader fr = new FileReader(f);
        fr.read(content);
        TestUtils.checkSyntax(pathTarget);
    }

    @Test
    public void testAMBAsimpleCT() throws IOException {
        String pathSource = "example/amba/ahb_ct_simple/example_ast.ast.xml";
        String pathTarget = "example/amba/ahb_ct_simple/example.uppaal.xml";
        File f = new File(pathTarget);
        if (f.exists()) {
            f.delete();
        }
        String[] args = new String[]{"-i", pathSource, "-o", pathTarget};
        Engine.main(args);
        f = new File(pathTarget);
        TLMTest.assertTrue((String)("File " + pathTarget + " has not been created."), (boolean)f.exists());
        char[] content = new char[(int)f.length()];
        FileReader fr = new FileReader(f);
        fr.read(content);
        TestUtils.checkSyntax(pathTarget);
    }

    @Test
    public void testAMBAsimpleCTwithPEQFile() throws IOException {
        String pathSource = "example/amba/ahb_ct_simple/example_ast.ast.xml";
        String pathTarget = "example/amba/ahb_ct_simple/example.uppaal.xml";
        String peqFile = "example/amba/ahb_ct_simple/example.peq";
        File f = new File(pathTarget);
        if (f.exists()) {
            f.delete();
        }
        String[] args = new String[]{"-i", pathSource, "-o", pathTarget, "-p", peqFile};
        Engine.main(args);
        f = new File(pathTarget);
        TLMTest.assertTrue((String)("File " + pathTarget + " has not been created."), (boolean)f.exists());
        char[] content = new char[(int)f.length()];
        FileReader fr = new FileReader(f);
        fr.read(content);
        TestUtils.checkSyntax(pathTarget);
    }

    @Test
    public void testMultiSocketTimed() throws IOException {
        String pathSource = "example/amba/multisocket_timed/example_ast.ast.xml";
        String pathTarget = "example/amba/multisocket_timed/example.uppaal.xml";
        File f = new File(pathTarget);
        if (f.exists()) {
            f.delete();
        }
        String[] args = new String[]{"-i", pathSource, "-o", pathTarget};
        Engine.main(args);
        f = new File(pathTarget);
        TLMTest.assertTrue((String)("File " + pathTarget + " has not been created."), (boolean)f.exists());
        char[] content = new char[(int)f.length()];
        FileReader fr = new FileReader(f);
        fr.read(content);
        TestUtils.checkSyntax(pathTarget);
    }

    @Test
    public void testMultiSocketUntimed() throws IOException {
        String pathSource = "example/amba/multisocket_untimed/example_ast.ast.xml";
        String pathTarget = "example/amba/multisocket_untimed/example.uppaal.xml";
        File f = new File(pathTarget);
        if (f.exists()) {
            f.delete();
        }
        String[] args = new String[]{"-i", pathSource, "-o", pathTarget};
        Engine.main(args);
        f = new File(pathTarget);
        TLMTest.assertTrue((String)("File " + pathTarget + " has not been created."), (boolean)f.exists());
        char[] content = new char[(int)f.length()];
        FileReader fr = new FileReader(f);
        fr.read(content);
        TestUtils.checkSyntax(pathTarget);
    }

    @Test
    public void testAMBAMultiSocket() throws IOException {
        String pathSource = "example/amba/multisocket/example_ast.ast.xml";
        String pathTarget = "example/amba/multisocket/example.uppaal.xml";
        File f = new File(pathTarget);
        if (f.exists()) {
            f.delete();
        }
        String[] args = new String[]{"-i", pathSource, "-o", pathTarget};
        Engine.main(args);
        f = new File(pathTarget);
        TLMTest.assertTrue((String)("File " + pathTarget + " has not been created."), (boolean)f.exists());
        char[] content = new char[(int)f.length()];
        FileReader fr = new FileReader(f);
        fr.read(content);
        TestUtils.checkSyntax(pathTarget);
    }
}

