/*
 * Decompiled with CFR 0.152.
 */
package de.tub.pes.state.test;

import de.tub.pes.state.engine.Engine;
import de.tub.pes.state.model.Module;
import de.tub.pes.state.util.TestUtils;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import junit.framework.TestCase;
import org.junit.Test;

public class StructTest
extends TestCase {
    public void testPacketSwitch() throws IOException {
        String pathSource = "example/pkt_switch/pkt_switch_1m2s_struct/pkt_switch.ast.xml";
        String pathTarget = "example/pkt_switch/pkt_switch_1m2s_struct/pkt_switch.uppaal.xml";
        File f = new File(pathTarget);
        if (f.exists()) {
            f.delete();
        }
        String[] args = new String[]{"-i", pathSource, "-o", pathTarget};
        Engine.main(args);
        f = new File(pathTarget);
        StructTest.assertTrue((String)("File " + pathTarget + " has not been created."), (boolean)f.exists());
        char[] content = new char[(int)f.length()];
        FileReader fr = new FileReader(f);
        fr.read(content);
        String contentString = String.copyValueOf(content);
        StructTest.assertTrue((String)"The UPPAAL model does not contain a switch_reg struct.", (boolean)contentString.contains("typedef struct {" + Module.END_LINE + "\tpkt val;" + Module.END_LINE + "\tint free;" + Module.END_LINE + "} switch_reg;" + Module.END_LINE));
        StructTest.assertTrue((String)"The UPPAAL model does not contain a fifo struct.", (boolean)contentString.contains("typedef struct {" + Module.END_LINE + "\tpkt pkt0;" + Module.END_LINE + "\tpkt pkt1;" + Module.END_LINE + "\tpkt pkt2;" + Module.END_LINE + "\tpkt pkt3;" + Module.END_LINE + "\tint full;" + Module.END_LINE + "\tint empty;" + Module.END_LINE + "\tint pntr;" + Module.END_LINE + "} fifo;" + Module.END_LINE));
        StructTest.assertTrue((String)"The UPPAAL model does not contain a pkt struct.", (boolean)contentString.contains("typedef struct {" + Module.END_LINE + "\tint data;" + Module.END_LINE + "\tint id;" + Module.END_LINE + "\tint dest0;" + Module.END_LINE + "\tint dest1;" + Module.END_LINE + "} pkt;" + Module.END_LINE));
        StructTest.assertTrue((String)"The UPPAAL model does not contain a correct instance of the pkt struct.", (boolean)contentString.contains("pkt sender0"));
        TestUtils.checkSyntax(pathTarget);
    }

    @Test
    public void testLocalStruct() throws IOException {
        String pathSource = "example/struct_examples/structs_as_locals/prod_cons_ast.ast.xml";
        String pathTarget = "example/struct_examples/structs_as_locals/prod_cons.uppaal.xml";
        File f = new File(pathTarget);
        if (f.exists()) {
            f.delete();
        }
        String[] args = new String[]{"-i", pathSource, "-o", pathTarget};
        Engine.main(args);
        f = new File(pathTarget);
        StructTest.assertTrue((String)("File " + pathTarget + " has not been created."), (boolean)f.exists());
        TestUtils.checkSyntax(pathTarget);
    }

    @Test
    public void testMultipleStructs() throws IOException {
        String pathSource = "example/struct_examples/multiple_local_structs/prod_cons_ast.ast.xml";
        String pathTarget = "example/struct_examples/multiple_local_structs/prod_cons.uppaal.xml";
        File f = new File(pathTarget);
        if (f.exists()) {
            f.delete();
        }
        String[] args = new String[]{"-i", pathSource, "-o", pathTarget};
        Engine.main(args);
        f = new File(pathTarget);
        StructTest.assertTrue((String)("File " + pathTarget + " has not been created."), (boolean)f.exists());
        TestUtils.checkSyntax(pathTarget);
    }

    @Test
    public void testNestedStructs() throws IOException {
        String pathSource = "example/struct_examples/nested_structs/prod_cons_ast.ast.xml";
        String pathTarget = "example/struct_examples/nested_structs/prod_cons.uppaal.xml";
        File f = new File(pathTarget);
        if (f.exists()) {
            f.delete();
        }
        String[] args = new String[]{"-i", pathSource, "-o", pathTarget};
        Engine.main(args);
        f = new File(pathTarget);
        StructTest.assertTrue((String)("File " + pathTarget + " has not been created."), (boolean)f.exists());
        char[] content = new char[(int)f.length()];
        FileReader fr = new FileReader(f);
        fr.read(content);
        String contentString = String.copyValueOf(content);
        StructTest.assertTrue((String)"The Uppaal Model does not contain a postincrement for p.p1.data2.", (boolean)contentString.contains("p.p1.data2++"));
        TestUtils.checkSyntax(pathTarget);
    }

    @Test
    public void testConditionsWithStructs() throws IOException {
        String pathSource = "example/struct_examples/structs_in_conditions/prod_cons_ast.ast.xml";
        String pathTarget = "example/struct_examples/structs_in_conditions/prod_cons.uppaal.xml";
        File f = new File(pathTarget);
        if (f.exists()) {
            f.delete();
        }
        String[] args = new String[]{"-i", pathSource, "-o", pathTarget};
        Engine.main(args);
        TestUtils.checkSyntax(pathTarget);
    }

    @Test
    public void testClassStructWithMethods() throws IOException {
        String pathSource = "example/struct_examples/struct_in_class_with_method/prod_cons_ast.ast.xml";
        String pathTarget = "example/struct_examples/struct_in_class_with_method/prod_cons.uppaal.xml";
        File f = new File(pathTarget);
        if (f.exists()) {
            f.delete();
        }
        String[] args = new String[]{"-i", pathSource, "-o", pathTarget};
        Engine.main(args);
        TestUtils.checkSyntax(pathTarget);
    }
}

