/*
 * Decompiled with CFR 0.152.
 */
package de.tub.pes.state.test;

import de.tub.pes.state.engine.Engine;
import de.tub.pes.state.util.TestUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import junit.framework.TestCase;
import org.junit.Test;

public class ExampleTests
extends TestCase {
    public void testPostfix() {
        String pathSource = "example/postfix/test_ast.ast.xml";
        String pathTarget = "example/postfix/test.uppaal.xml";
        String[] args = new String[]{"-i", pathSource, "-o", pathTarget};
        File f = new File(pathTarget);
        if (f.exists()) {
            f.delete();
        }
        Engine.main(args);
        TestUtils.checkSyntax(pathTarget);
        f = new File(pathTarget);
        ExampleTests.assertTrue((String)("File " + pathTarget + " has not been created."), (boolean)f.exists());
        char[] content = new char[(int)f.length()];
        FileReader fr = null;
        try {
            fr = new FileReader(f);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        try {
            fr.read(content);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String contentString = String.copyValueOf(content);
        ExampleTests.assertTrue((String)"The UPPAAL model does not contain a postfix increment.", (boolean)contentString.contains("k++"));
    }

    public void testSimpleFifo() {
        String pathSource = "example/simple_fifo/prod_cons_ast.ast.xml";
        String pathTarget = "example/simple_fifo/prod_cons.uppaal.xml";
        String[] args = new String[]{"-i", pathSource, "-o", pathTarget};
        Engine.main(args);
        TestUtils.checkSyntax(pathTarget);
    }

    @Test
    public void testFifo1Prod1Cons() {
        String pathSource = "example/sc_fifo/1prod1cons_ast.ast.xml";
        String pathTarget = "example/sc_fifo/1prod1cons.uppaal.xml";
        String[] args = new String[]{"-i", pathSource, "-o", pathTarget};
        Engine.main(args);
        TestUtils.checkSyntax(pathTarget);
    }

    public void testPktSwitch() {
        String pathSource = "example/pkt_switch/pkt_switch_1m1s/pkt_switch.ast.xml";
        String pathTarget = "example/pkt_switch/pkt_switch_1m1s/pkt_switch.uppaal.xml";
        String[] args = new String[]{"-i", pathSource, "-o", pathTarget};
        Engine.main(args);
        TestUtils.checkSyntax(pathTarget);
    }

    public void testABS() {
        String pathSource = "example/simple_ABS/ABS_tb_ast.ast.xml";
        String pathTarget = "example/simple_ABS/ABS_tb.uppaal.xml";
        String[] args = new String[]{"-i", pathSource, "-o", pathTarget};
        Engine.main(args);
        TestUtils.checkSyntax(pathTarget);
    }
}

