/*
 * Decompiled with CFR 0.152.
 */
package de.tub.pes.state.optimization;

import de.tub.pes.state.model.TAInteger;
import de.tub.pes.state.model.TAModel;
import de.tub.pes.state.model.TAStruct;
import de.tub.pes.state.model.TATemplate;
import de.tub.pes.state.model.TATransition;
import de.tub.pes.state.model.TAVariable;
import de.tub.pes.state.optimization.AbstractOptimizer;

public class VariableResetOptimizer
extends AbstractOptimizer {
    private int varCount = 0;

    @Override
    public void run(TAModel tAModel) {
        for (String string : tAModel.getTemplates().keySet()) {
            TATemplate tATemplate = tAModel.getTemplates().get(string);
            for (TATransition tATransition : tATemplate.getIncomingTransitions(tATemplate.getInitLocation())) {
                for (TAVariable tAVariable : tATemplate.getLocalVars()) {
                    this.resetVar(tATransition, tAVariable);
                }
            }
        }
        this.reportStats("Reseted " + this.varCount + " local variables.");
    }

    private void resetVar(TATransition tATransition, TAVariable tAVariable) {
        if (tAVariable instanceof TAInteger) {
            tATransition.addUpdateExpression(((TAInteger)tAVariable).getResetExpr());
            ++this.varCount;
        } else if (tAVariable instanceof TAStruct) {
            tATransition.addUpdateExpression(((TAStruct)tAVariable).getResetExpr());
            ++this.varCount;
        }
    }
}

