/*
 * Decompiled with CFR 0.152.
 */
package de.tub.pes.state.optimization;

import de.tub.pes.state.model.TALocation;
import de.tub.pes.state.model.TAModel;
import de.tub.pes.state.model.TATemplate;
import de.tub.pes.state.model.TATransition;
import de.tub.pes.state.model.expression.Expression;
import de.tub.pes.state.optimization.AbstractOptimizer;
import java.util.LinkedList;
import java.util.List;

public class TransitionOptimizer
extends AbstractOptimizer {
    int transCount;
    int locCount;

    @Override
    public void run(TAModel tAModel) {
        this.transCount = 0;
        this.locCount = 0;
        for (String string : tAModel.getTemplates().keySet()) {
            TATemplate tATemplate = tAModel.getTemplates().get(string);
            this.deleteEmptyTransitions(tATemplate);
            this.deleteTransitLocations(tATemplate);
        }
        this.reportStats("Deleted " + this.transCount + " Transitions.");
        this.reportStats("Deleted " + this.locCount + " Locations.");
    }

    private void deleteEmptyTransitions(TATemplate tATemplate) {
        for (TATransition tATransition : this.getEmptyTransitions(tATemplate)) {
            TALocation tALocation = tATransition.getStart();
            TALocation tALocation2 = tATransition.getEnd();
            List<TATransition> list = tATemplate.getOutgoingTransitions(tALocation);
            if (!tALocation.isUrgent() || list.size() != 1) continue;
            if (tATemplate.getInitLocation() == tALocation) {
                tATemplate.setInitLocation(tALocation2);
            }
            for (TATransition tATransition2 : tATemplate.getIncomingTransitions(tALocation)) {
                tATransition2.setEnd(tALocation2);
            }
            tATemplate.getLocations().remove(tALocation);
            tATemplate.getTransitions().remove(tATransition);
            ++this.locCount;
            ++this.transCount;
        }
    }

    private LinkedList<TALocation> deleteTransitLocations(TATemplate tATemplate) {
        LinkedList<TALocation> linkedList = new LinkedList<TALocation>();
        for (TALocation tALocation : tATemplate.getLocations()) {
            if (!tALocation.isUrgent()) continue;
            List<TATransition> list = tATemplate.getIncomingTransitions(tALocation);
            List<TATransition> list2 = tATemplate.getOutgoingTransitions(tALocation);
            if (list.size() != 1 || list2.size() != 1) continue;
            TATransition tATransition = list.get(0);
            TATransition tATransition2 = list2.get(0);
            if (!tATransition.getSelect().isEmpty() || tATransition.getGuard() != null || tATransition.getSync() != null && tATransition.getSync().toString().indexOf("?") != tATransition.getSync().toString().length() - 1 || !tATransition2.getSelect().isEmpty() || tATransition2.getGuard() != null || tATransition2.getSync() != null) continue;
            tATransition.setEnd(tATransition2.getEnd());
            tATransition2.setStart(tATransition.getStart());
            for (Expression expression : tATransition2.getUpdate()) {
                tATransition.addUpdateExpression(expression);
            }
            tATemplate.getTransitions().remove(tATransition2);
            ++this.transCount;
            linkedList.add(tALocation);
        }
        for (TALocation tALocation : linkedList) {
            tATemplate.getLocations().remove(tALocation);
            ++this.locCount;
        }
        return linkedList;
    }

    private LinkedList<TATransition> getEmptyTransitions(TATemplate tATemplate) {
        LinkedList<TATransition> linkedList = new LinkedList<TATransition>();
        for (TATransition tATransition : tATemplate.getTransitions()) {
            if (!tATransition.getSelect().isEmpty() || tATransition.getGuard() != null || tATransition.getSync() != null || !tATransition.getUpdate().isEmpty()) continue;
            linkedList.add(tATransition);
        }
        return linkedList;
    }
}

