/*
 * Decompiled with CFR 0.152.
 */
package de.tub.pes.state.optimization;

import de.tub.pes.state.engine.TransformerFactory;
import de.tub.pes.state.model.TAModel;
import de.tub.pes.state.optimization.Optimizer;
import de.tub.pes.state.util.IOUtil;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLClassLoader;

public class OptimizationEngine {
    public static String OPTIMIZERS_CFG_FILE = "config/optimizers.properties";

    public static void run(TAModel tAModel) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(IOUtil.getInputStream(OPTIMIZERS_CFG_FILE)));
            while (bufferedReader.ready()) {
                String string = bufferedReader.readLine();
                string = string.replaceAll("^[ \\s\\t]*", "");
                if ((string = string.replaceAll("[ \\s\\t]*$", "")) == "" || string.startsWith("#")) continue;
                URL[] uRLArray = new URL[]{TransformerFactory.class.getResource("")};
                URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
                try {
                    Optimizer optimizer = (Optimizer)uRLClassLoader.loadClass(string).newInstance();
                    optimizer.run(tAModel);
                }
                catch (InstantiationException instantiationException) {
                    System.out.println("Can not instantiate optimizer '" + string + "'. Skipping.");
                }
                catch (IllegalAccessException illegalAccessException) {
                    System.out.println("Can not open optimizer '" + string + "'. Skipping.");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.out.println("Can not find optimizer '" + string + "'. Skipping.");
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Can not find optimization cfg file. Skipping.");
            return;
        }
        catch (IOException iOException) {
            System.out.println("Can not open optimization cfg file. Skipping.");
            return;
        }
    }
}

