/*
 * Decompiled with CFR 0.152.
 */
package de.tub.pes.state.model;

import de.tub.pes.state.model.TALocation;
import de.tub.pes.state.model.expression.Expression;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.LinkedList;
import java.util.List;

public class TATransition {
    private TALocation start;
    private TALocation end;
    private List<Expression> select;
    private Expression guard = null;
    private Expression sync = null;
    private List<Expression> update;

    public TATransition() {
        this.select = new LinkedList<Expression>();
        this.update = new LinkedList<Expression>();
    }

    public TATransition(TALocation tALocation, TALocation tALocation2) {
        this.start = tALocation;
        this.end = tALocation2;
        this.select = new LinkedList<Expression>();
        this.update = new LinkedList<Expression>();
    }

    public TATransition(TALocation tALocation, TALocation tALocation2, Expression expression) {
        this.start = tALocation;
        this.end = tALocation2;
        this.sync = expression;
        this.select = new LinkedList<Expression>();
        this.update = new LinkedList<Expression>();
    }

    public TALocation getStart() {
        return this.start;
    }

    public void setStart(TALocation tALocation) {
        this.start = tALocation;
    }

    public TALocation getEnd() {
        return this.end;
    }

    public void setEnd(TALocation tALocation) {
        this.end = tALocation;
    }

    public Expression getGuard() {
        return this.guard;
    }

    public void setGuard(Expression expression) {
        this.guard = expression;
    }

    public List<Expression> getSelect() {
        return this.select;
    }

    public void addSelectExpression(Expression expression) {
        this.select.add(expression);
    }

    public Expression getSync() {
        return this.sync;
    }

    public void setSync(Expression expression) {
        this.sync = expression;
    }

    public List<Expression> getUpdate() {
        return this.update;
    }

    public void addUpdateExpression(Expression expression) {
        ((LinkedList)this.update).addLast(expression);
    }

    public void addUpdateExpressionFront(Expression expression) {
        ((LinkedList)this.update).addFirst(expression);
    }

    public void print(OutputStreamWriter outputStreamWriter) throws IOException {
        outputStreamWriter.write("<transition>\n");
        outputStreamWriter.write("<source ref=\"id" + this.start.getId() + "\"/>\n");
        outputStreamWriter.write("<target ref=\"id" + this.end.getId() + "\"/>\n");
        this.printSelect(outputStreamWriter);
        this.printGuard(outputStreamWriter);
        this.printSync(outputStreamWriter);
        this.printUpdate(outputStreamWriter);
        outputStreamWriter.write("</transition>\n");
    }

    public void printSelect(OutputStreamWriter outputStreamWriter) throws IOException {
        if (this.select != null && this.select.size() > 0) {
            outputStreamWriter.write("<label kind=\"select\">");
            this.select.get(0).print(outputStreamWriter);
            for (int i = 1; i < this.select.size(); ++i) {
                outputStreamWriter.write(", ");
                this.select.get(i).print(outputStreamWriter);
            }
            outputStreamWriter.write("</label>\n");
        }
    }

    public void printGuard(OutputStreamWriter outputStreamWriter) throws IOException {
        if (this.guard != null) {
            outputStreamWriter.write("<label kind=\"guard\">\n");
            this.guard.print(outputStreamWriter);
            outputStreamWriter.write("</label>\n");
        }
    }

    public void printSync(OutputStreamWriter outputStreamWriter) throws IOException {
        if (this.sync != null) {
            outputStreamWriter.write("<label kind=\"synchronisation\">\n");
            this.sync.print(outputStreamWriter);
            outputStreamWriter.write("</label>\n");
        }
    }

    public void printUpdate(OutputStreamWriter outputStreamWriter) throws IOException {
        if (this.update != null && this.update.size() > 0) {
            outputStreamWriter.write("<label kind=\"assignment\">\n");
            this.update.get(0).print(outputStreamWriter);
            for (int i = 1; i < this.update.size(); ++i) {
                outputStreamWriter.write(",\n");
                this.update.get(i).print(outputStreamWriter);
            }
            outputStreamWriter.write("</label>\n");
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("From: " + this.start + ", To: " + this.end);
        stringBuilder.append(this.guard != null ? ", guard = " + this.guard : "");
        stringBuilder.append(this.sync != null ? ", sync = " + this.sync : "");
        if (this.update != null && !this.update.isEmpty()) {
            stringBuilder.append(this.update.get(0));
            for (int i = 1; i < this.update.size(); ++i) {
                stringBuilder.append(", ");
                stringBuilder.append(this.update.get(i));
            }
        }
        return stringBuilder.toString();
    }
}

