/*
 * Decompiled with CFR 0.152.
 */
package de.tub.pes.state.model;

import de.tub.pes.state.model.Module;
import de.tub.pes.state.model.TAArray;
import de.tub.pes.state.model.TAChannel;
import de.tub.pes.state.model.TAFunction;
import de.tub.pes.state.model.TALocation;
import de.tub.pes.state.model.TATemplateInstance;
import de.tub.pes.state.model.TATransition;
import de.tub.pes.state.model.TAVariable;
import de.tub.pes.state.model.expression.Expression;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.LinkedList;
import java.util.List;

public class TATemplate {
    private String name;
    private List<TAVariable> parameters;
    private List<TAVariable> localVars;
    private List<TAFunction> localFuns;
    private List<TALocation> locations;
    private List<TATransition> transitions;
    private TALocation initLocation = null;
    private boolean testTemplate = false;
    private boolean monitorTemplate = false;

    public TATemplate(String string) {
        this.name = string;
        this.parameters = new LinkedList<TAVariable>();
        this.localVars = new LinkedList<TAVariable>();
        this.localFuns = new LinkedList<TAFunction>();
        this.locations = new LinkedList<TALocation>();
        this.transitions = new LinkedList<TATransition>();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean isTestTemplate() {
        return this.testTemplate;
    }

    public void setTestTemplate() {
        this.testTemplate = true;
    }

    public boolean isMonitorTemplate() {
        return this.monitorTemplate;
    }

    public void setMonitorTemplate() {
        this.monitorTemplate = true;
    }

    public List<TAVariable> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<TAVariable> list) {
        this.parameters = list;
    }

    public TAVariable getParameter(String string) {
        for (TAVariable tAVariable : this.parameters) {
            if (!tAVariable.getName().equals(string)) continue;
            return tAVariable;
        }
        return null;
    }

    public void addParameter(TAVariable tAVariable) {
        this.parameters.add(tAVariable);
    }

    public TAVariable getLocalVar(String string) {
        for (TAVariable tAVariable : this.localVars) {
            if (!string.equals(tAVariable.getName())) continue;
            return tAVariable;
        }
        return null;
    }

    public List<TAVariable> getLocalVars() {
        return this.localVars;
    }

    public void addLocalVar(TAVariable tAVariable) {
        if (this.localVars.contains(tAVariable)) {
            System.out.println("WARNING: local variable " + tAVariable.getName() + " cannot be added more than once to template " + this.getName() + "!");
        } else {
            this.localVars.add(tAVariable);
        }
    }

    public boolean containsLocalVar(String string) {
        for (TAVariable tAVariable : this.localVars) {
            if (!tAVariable.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public TAFunction getLocalFun(String string) {
        for (TAFunction tAFunction : this.localFuns) {
            if (!string.equals(tAFunction.getName())) continue;
            return tAFunction;
        }
        return null;
    }

    public List<TAFunction> getLocalFuns() {
        return this.localFuns;
    }

    public void addLocalFun(TAFunction tAFunction) {
        this.localFuns.add(tAFunction);
    }

    public List<TALocation> getLocations() {
        return this.locations;
    }

    public void addLocation(TALocation tALocation) {
        this.locations.add(tALocation);
    }

    public TALocation createLocation(String string) {
        TALocation tALocation = new TALocation(string);
        this.locations.add(tALocation);
        return tALocation;
    }

    public TALocation createLocation() {
        TALocation tALocation = new TALocation();
        this.locations.add(tALocation);
        return tALocation;
    }

    public TALocation createUrgentLocation() {
        TALocation tALocation = new TALocation();
        tALocation.setUrgent(true);
        this.locations.add(tALocation);
        return tALocation;
    }

    public TALocation createCommittedLocation() {
        TALocation tALocation = new TALocation();
        tALocation.setCommitted(true);
        this.locations.add(tALocation);
        return tALocation;
    }

    public TALocation createStandardLocation() {
        TALocation tALocation = new TALocation();
        tALocation.setUrgent(true);
        this.locations.add(tALocation);
        return tALocation;
    }

    public void setLocations(List<TALocation> list) {
        this.locations = list;
    }

    public List<TATransition> getTransitions() {
        return this.transitions;
    }

    public void addTransition(TATransition tATransition) {
        this.transitions.add(tATransition);
    }

    public void setTransitions(List<TATransition> list) {
        this.transitions = list;
    }

    public TATemplateInstance getInstance(String string) {
        return new TATemplateInstance(this, string);
    }

    public TALocation getInitLocation() {
        return this.initLocation;
    }

    public void setInitLocation(TALocation tALocation) {
        this.initLocation = tALocation;
        if (!this.locations.contains(tALocation)) {
            this.locations.add(tALocation);
        }
    }

    public List<TATransition> getOutgoingTransitions(TALocation tALocation) {
        LinkedList<TATransition> linkedList = new LinkedList<TATransition>();
        for (TATransition tATransition : this.transitions) {
            if (tATransition.getStart() != tALocation) continue;
            linkedList.add(tATransition);
        }
        return linkedList;
    }

    public List<TATransition> getIncomingTransitions(TALocation tALocation) {
        LinkedList<TATransition> linkedList = new LinkedList<TATransition>();
        for (TATransition tATransition : this.transitions) {
            if (tATransition.getEnd() != tALocation) continue;
            linkedList.add(tATransition);
        }
        return linkedList;
    }

    public TATemplate createCopy(String string) {
        TATemplate tATemplate = new TATemplate(string);
        for (TAVariable object : this.parameters) {
            tATemplate.addParameter(object.createCopy(""));
        }
        for (TAVariable tAVariable : this.localVars) {
            tATemplate.addLocalVar(tAVariable.createCopy(""));
        }
        for (TAFunction tAFunction : this.localFuns) {
            tATemplate.addLocalFun(tAFunction.createCopy());
        }
        for (TALocation tALocation : this.locations) {
            TALocation tALocation2 = tALocation.createCopy();
            tATemplate.addLocation(tALocation2);
            if (tALocation.getId() != this.initLocation.getId()) continue;
            tATemplate.setInitLocation(tALocation2);
        }
        for (TATransition tATransition : this.transitions) {
            tATemplate.addTransition(tATransition);
        }
        return tATemplate;
    }

    public void print(OutputStreamWriter outputStreamWriter) throws IOException {
        int n;
        outputStreamWriter.write("<template>" + Module.END_LINE);
        outputStreamWriter.write("<name>" + this.name + "</name>" + Module.END_LINE);
        outputStreamWriter.write("<parameter>");
        for (n = 0; n < this.parameters.size(); ++n) {
            if (n != 0) {
                outputStreamWriter.write(", ");
            }
            this.parameters.get(n).printAsParam(outputStreamWriter);
        }
        outputStreamWriter.write("</parameter>" + Module.END_LINE);
        outputStreamWriter.write("<declaration>");
        for (n = 0; n < this.localVars.size(); ++n) {
            this.localVars.get(n).print(outputStreamWriter);
        }
        for (n = 0; n < this.localFuns.size(); ++n) {
            this.localFuns.get(n).print(outputStreamWriter);
        }
        outputStreamWriter.write("</declaration>" + Module.END_LINE);
        for (n = 0; n < this.locations.size(); ++n) {
            this.locations.get(n).print(outputStreamWriter);
        }
        if (this.initLocation != null) {
            outputStreamWriter.write("<init ref=\"id" + this.initLocation.getId() + "\"/>" + Module.END_LINE);
        }
        for (n = 0; n < this.transitions.size(); ++n) {
            this.transitions.get(n).print(outputStreamWriter);
        }
        outputStreamWriter.write("</template>" + Module.END_LINE);
    }

    public String toString() {
        return this.name;
    }

    public void removeLocalVars(LinkedList<TAVariable> linkedList) {
        this.localVars.removeAll(linkedList);
    }

    public void addLocations(TALocation ... tALocationArray) {
        for (TALocation tALocation : tALocationArray) {
            this.addLocation(tALocation);
        }
    }

    public void addLocalVars(TAVariable ... tAVariableArray) {
        for (TAVariable tAVariable : tAVariableArray) {
            this.addLocalVar(tAVariable);
        }
    }

    public void addTransitions(TATransition ... tATransitionArray) {
        for (TATransition tATransition : tATransitionArray) {
            this.addTransition(tATransition);
        }
    }

    public boolean isVarUsedInTemplate(TAVariable tAVariable) {
        for (TALocation object : this.getLocations()) {
            Expression expression = object.getInvariant2();
            if (expression == null || !expression.contains(tAVariable)) continue;
            return true;
        }
        for (TATransition tATransition : this.getTransitions()) {
            for (Expression expression : tATransition.getSelect()) {
                if (!expression.contains(tAVariable)) continue;
                return true;
            }
            for (Expression expression : tATransition.getUpdate()) {
                if (!expression.contains(tAVariable)) continue;
                return true;
            }
            if (tATransition.getGuard() != null && tATransition.getGuard().contains(tAVariable)) {
                return true;
            }
            if (tATransition.getSync() == null || !tATransition.getSync().contains(tAVariable)) continue;
            return true;
        }
        return false;
    }

    public List<TAVariable> getCalledCtrlChannels() {
        LinkedList<TAVariable> linkedList = new LinkedList<TAVariable>();
        TATransition tATransition = null;
        for (TATransition object : this.getTransitions()) {
            if (object.getStart().getId() != this.getInitLocation().getId()) continue;
            tATransition = object;
            break;
        }
        if (tATransition == null) {
            return null;
        }
        for (TAVariable tAVariable : this.getParameters()) {
            if (!(tAVariable instanceof TAChannel) && !(tAVariable instanceof TAArray) || tATransition.getSync().contains(tAVariable) || !tAVariable.getName().matches(".*ctrl") || !this.isVarUsedInTemplate(tAVariable)) continue;
            linkedList.add(tAVariable);
        }
        return linkedList;
    }

    public TAVariable getCtrlParameter() {
        String string;
        int n;
        TATransition tATransition;
        List<TATransition> list = this.getOutgoingTransitions(this.getInitLocation());
        if (list.size() == 1 && (tATransition = list.get(0)).getSync() != null && (n = (string = tATransition.getSync().toString()).indexOf("ctrl?")) >= 0 && n >= string.length() - "ctrl? ".length()) {
            return this.getParameter(string.replaceAll("\\?", ""));
        }
        return null;
    }
}

