/*
 * Decompiled with CFR 0.152.
 */
package de.tub.pes.state.model;

import de.tub.pes.state.model.CClass;
import de.tub.pes.state.model.Module;
import de.tub.pes.state.model.TAArray;
import de.tub.pes.state.model.TAModel;
import de.tub.pes.state.model.TAVariable;
import de.tub.pes.state.model.expression.BinaryExpression;
import de.tub.pes.state.model.expression.Expression;
import de.tub.pes.state.model.expression.VariableExpression;
import java.io.IOException;
import java.io.OutputStreamWriter;

public class TAStruct
extends TAVariable {
    private String name;
    private String prefix;
    private CClass type;
    boolean isRef = false;

    public CClass getType() {
        return this.type;
    }

    public void setType(CClass cClass) {
        this.type = cClass;
    }

    public TAStruct(String string, String string2, CClass cClass) {
        this.prefix = string;
        this.name = string2;
        this.type = cClass;
    }

    @Override
    public TAVariable createCopy(String string) {
        TAStruct tAStruct = new TAStruct(string + this.prefix, this.name, this.type);
        tAStruct.isRef = this.isRef;
        return tAStruct;
    }

    @Override
    public String getDummyName(TAModel tAModel) {
        return "dummyStruct";
    }

    @Override
    public String getName() {
        return this.prefix + this.name;
    }

    @Override
    public void print(OutputStreamWriter outputStreamWriter) throws IOException {
        outputStreamWriter.write(this.type.getName() + " " + this.prefix + this.name + ";" + Module.END_LINE);
    }

    @Override
    public void printAsParam(OutputStreamWriter outputStreamWriter) throws IOException {
        outputStreamWriter.write(this.type.getName() + " &amp;" + this.getName());
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public String createDeclarationString() {
        return this.type.getName() + " " + this.getName() + ";" + Module.END_LINE;
    }

    public String getUnprefixedName() {
        return this.name;
    }

    @Override
    public void setRef(boolean bl) {
        this.isRef = bl;
    }

    @Override
    public boolean isRef() {
        return this.isRef;
    }

    public Expression getResetExpr() {
        BinaryExpression binaryExpression = new BinaryExpression((Expression)new VariableExpression(this), this.type.getEmptyElementString(), "=");
        return binaryExpression;
    }

    @Override
    public TAArray asArray(int n) {
        TAArray tAArray = new TAArray(this.getName(), this.getType().getName(), "1", true, false);
        tAArray.addSizeOfDimension(n, 0);
        return tAArray;
    }
}

