/*
 * Decompiled with CFR 0.152.
 */
package de.tub.pes.state.model;

import de.tub.pes.state.model.CClass;
import de.tub.pes.state.model.Constants;
import de.tub.pes.state.model.Module;
import de.tub.pes.state.model.TALocation;
import de.tub.pes.state.model.TAStruct;
import de.tub.pes.state.model.TATemplate;
import de.tub.pes.state.model.TATemplateInstance;
import de.tub.pes.state.model.TATransition;
import de.tub.pes.state.model.TAVariable;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class TAModel {
    private Map<String, TATemplate> templates = new HashMap<String, TATemplate>();
    private LinkedList<CClass> classes;
    private Map<String, TATemplateInstance> systemDeclaration = new HashMap<String, TATemplateInstance>();
    private LinkedList<TAVariable> declaration = new LinkedList();
    private HashMap<String, Integer> peqSizeMap;
    private static final String XMLHEADER = "<?xml version='1.0' encoding='utf-8'?>" + Module.END_LINE + "<!DOCTYPE nta PUBLIC '-//Uppaal Team//DTD Flat System 1.1//EN' 'http://www.it.uu.se/research/group/darts/uppaal/flat-1_1.dtd'>" + Module.END_LINE;

    public Map<String, TATemplate> getTemplates() {
        return this.templates;
    }

    public TATemplate getTemplate(String string) {
        TATemplate tATemplate = this.templates.get(string);
        return tATemplate;
    }

    public void setTemplates(Map<String, TATemplate> map) {
        this.templates = map;
    }

    public Map<String, TATemplateInstance> getSystemDeclaration() {
        return this.systemDeclaration;
    }

    public void setSystemDeclaration(Map<String, TATemplateInstance> map) {
        this.systemDeclaration = map;
    }

    public TAVariable getGlobalVariable(String string) {
        if (string.contains("[")) {
            int n = string.indexOf("[");
            string = string.substring(0, n);
        }
        for (TAVariable tAVariable : this.declaration) {
            if (!tAVariable.getName().equals(string)) continue;
            return tAVariable;
        }
        return null;
    }

    public List<TAVariable> getDeclaration() {
        return this.declaration;
    }

    public void setDeclaration(LinkedList<TAVariable> linkedList) {
        this.declaration = linkedList;
    }

    public void addTemplate(TATemplate tATemplate) {
        this.templates.put(tATemplate.getName(), tATemplate);
    }

    public void addVariable(TAVariable tAVariable) {
        for (TAVariable tAVariable2 : this.declaration) {
            if (!tAVariable2.getName().equals(tAVariable.getName())) continue;
            return;
        }
        this.declaration.addLast(tAVariable);
    }

    public void addTemplateInstance(TATemplateInstance tATemplateInstance) {
        this.systemDeclaration.put(tATemplateInstance.getName(), tATemplateInstance);
    }

    public HashMap<String, Integer> getPeqSizeMap() {
        return this.peqSizeMap;
    }

    public void setPeqSizeMap(HashMap<String, Integer> hashMap) {
        if (hashMap.containsKey(Constants.GLOBAL_PEQ)) {
            Constants.GLOBAL_PEQ_SIZE = hashMap.get(Constants.GLOBAL_PEQ);
            hashMap.remove(Constants.GLOBAL_PEQ);
        }
        this.peqSizeMap = hashMap;
    }

    public void print(OutputStreamWriter outputStreamWriter) throws IOException {
        Object[] objectArray2;
        outputStreamWriter.write(XMLHEADER);
        outputStreamWriter.write("<nta>" + Module.END_LINE);
        outputStreamWriter.write("<declaration>" + Module.END_LINE);
        outputStreamWriter.write("const int BEGIN_REQ := 1;" + Module.END_LINE);
        outputStreamWriter.write("const int END_REQ := 2;" + Module.END_LINE);
        outputStreamWriter.write("const int BEGIN_RESP := 3;" + Module.END_LINE);
        outputStreamWriter.write("const int END_RESP := 4;" + Module.END_LINE);
        outputStreamWriter.write("const int TLM_OK_RESPONSE := 1;" + Module.END_LINE);
        outputStreamWriter.write("const int TLM_BURST_ERROR_RESPONSE := 2;" + Module.END_LINE);
        outputStreamWriter.write("const int TLM_GENERIC_ERROR_RESPONSE := 3;" + Module.END_LINE);
        outputStreamWriter.write("clock global;" + Module.END_LINE);
        for (CClass object2 : this.classes) {
            object2.print(outputStreamWriter);
        }
        for (TAVariable tAVariable : this.declaration) {
            tAVariable.print(outputStreamWriter);
        }
        outputStreamWriter.write("</declaration>" + Module.END_LINE);
        TreeMap<String, TATemplate> treeMap = new TreeMap<String, TATemplate>(this.templates);
        for (Object[] objectArray2 : treeMap.keySet()) {
            ((TATemplate)treeMap.get(objectArray2)).print(outputStreamWriter);
        }
        outputStreamWriter.write("<system>" + Module.END_LINE);
        Set<String> set = this.systemDeclaration.keySet();
        objectArray2 = set.toArray(new String[set.size()]);
        Arrays.sort(objectArray2);
        Object object = null;
        for (int i = 0; i < objectArray2.length; ++i) {
            Object object2 = objectArray2[i];
            object = object == null ? object2 : (String)object + "," + Module.END_LINE + (String)object2;
            this.systemDeclaration.get(object2).print(outputStreamWriter);
        }
        outputStreamWriter.write(Module.END_LINE + Module.END_LINE + "system " + (String)object + ";");
        outputStreamWriter.write("</system>" + Module.END_LINE);
        outputStreamWriter.write("</nta>" + Module.END_LINE);
    }

    public void labelLocations() {
        for (String string : this.templates.keySet()) {
            Object object;
            int n;
            TATemplate tATemplate = this.templates.get(string);
            if (tATemplate.isTestTemplate()) {
                n = 0;
                for (TALocation tALocation : tATemplate.getLocations()) {
                    tALocation.setName("tc" + n);
                    ++n;
                }
                object = tATemplate.getInitLocation();
                ((TALocation)object).setName("tc_start");
                for (TATransition tATransition : tATemplate.getIncomingTransitions((TALocation)object)) {
                    tATransition.getStart().setName("tc_end");
                }
            }
            if (!tATemplate.isMonitorTemplate()) continue;
            n = 0;
            for (TALocation tALocation : tATemplate.getLocations()) {
                tALocation.setName("mon" + n);
                ++n;
            }
            object = tATemplate.getInitLocation();
            ((TALocation)object).setName("mon_start");
            for (TATransition tATransition : tATemplate.getIncomingTransitions((TALocation)object)) {
                tATransition.getStart().setName("mon_end");
            }
        }
    }

    public void printStdOut() {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(System.out);
        try {
            this.print(outputStreamWriter);
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setStructs(LinkedList<CClass> linkedList) {
        this.classes = linkedList;
    }

    public void createGlobalStructs() {
        LinkedList linkedList = new LinkedList();
        for (TAVariable tAVariable : this.declaration) {
            if (!(tAVariable instanceof TAStruct)) continue;
        }
        this.declaration.addAll(linkedList);
    }

    public void addVariables(LinkedList<TAVariable> linkedList) {
        for (TAVariable tAVariable : linkedList) {
            this.addVariable(tAVariable);
        }
    }

    public HashMap<TATemplate, List<TAVariable>> createMethodCallerMap() {
        HashMap<TATemplate, List<TAVariable>> hashMap = new HashMap<TATemplate, List<TAVariable>>();
        for (String string : this.getTemplates().keySet()) {
            TATemplate tATemplate = this.getTemplates().get(string);
            hashMap.put(tATemplate, tATemplate.getCalledCtrlChannels());
        }
        return hashMap;
    }
}

