/*
 * Decompiled with CFR 0.152.
 */
package de.tub.pes.state.model;

import de.tub.pes.state.model.Module;
import de.tub.pes.state.model.TAArray;
import de.tub.pes.state.model.TAModel;
import de.tub.pes.state.model.TAVariable;
import de.tub.pes.state.model.expression.BinaryExpression;
import de.tub.pes.state.model.expression.Expression;
import de.tub.pes.state.model.expression.VariableExpression;
import java.io.IOException;
import java.io.OutputStreamWriter;

public class TAInteger
extends TAVariable {
    private String name;
    private String initVal;
    private int bits = 16;
    private String max;
    private boolean constant = false;
    private boolean init = false;
    private boolean ref = false;

    @Override
    public boolean isRef() {
        return this.ref;
    }

    @Override
    public void setRef(boolean bl) {
        this.ref = bl;
    }

    public TAInteger(String string) {
        this.name = string;
    }

    public TAInteger(String string, String string2, boolean bl) {
        this.name = string;
        this.initVal = string2;
        this.init = true;
        this.constant = bl;
    }

    public TAInteger(String string, int n, boolean bl) {
        this.name = string;
        this.initVal = Integer.toString(n);
        this.init = true;
        this.constant = bl;
    }

    public TAInteger(String string, String string2) {
        this.name = string;
        this.max = string2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    public String getInitValue() {
        return this.initVal;
    }

    public void setInitValue(String string) {
        this.initVal = string;
        this.init = true;
    }

    public void setInitValue(int n) {
        this.initVal = Integer.toString(n);
        this.init = true;
    }

    public String getMax() {
        return this.max;
    }

    public void setMax(String string) {
        this.max = string;
    }

    public boolean isConstant() {
        return this.constant;
    }

    public void setConstant(boolean bl) {
        this.constant = bl;
    }

    public boolean isInited() {
        return this.init;
    }

    @Override
    public TAVariable createCopy(String string) {
        TAInteger tAInteger;
        if (this.init) {
            tAInteger = new TAInteger(string + this.name, this.initVal, this.constant);
        } else {
            tAInteger = new TAInteger(string + this.name);
            tAInteger.setConstant(this.constant);
        }
        tAInteger.setBits(this.bits);
        tAInteger.setRef(this.ref);
        tAInteger.setMax(this.max);
        return tAInteger;
    }

    @Override
    public void print(OutputStreamWriter outputStreamWriter) throws IOException {
        String string = this.createDeclarationString();
        outputStreamWriter.write(string);
    }

    @Override
    public String createDeclarationString() {
        String string = "";
        if (this.constant) {
            string = string + "const ";
        }
        if (this.bits == 16 && this.max == null) {
            string = string + "int " + this.name + (this.init ? " := " + this.initVal : "") + ";" + Module.END_LINE;
        } else if (this.max == null) {
            long l = -(1L << (int)((long)this.bits));
            long l2 = -l;
            string = "int[" + l + ", " + l2 + "] " + this.name + (this.init ? " := " + this.initVal : "") + ";" + Module.END_LINE;
        } else {
            string = "int[0, " + this.max + "] " + this.name + (this.init ? " := " + this.initVal : "") + ";" + Module.END_LINE;
        }
        return string;
    }

    @Override
    public void printAsParam(OutputStreamWriter outputStreamWriter) throws IOException {
        String string = "";
        String string2 = "";
        if (this.constant) {
            string = string + "const ";
        } else {
            string2 = "&amp;";
        }
        if (this.bits == 16 && this.max == null) {
            string = string + "int " + string2 + this.name;
        } else if (this.max == null) {
            long l = -(1L << (int)((long)this.bits));
            long l2 = -l;
            string = string + "int[" + l + ", " + l2 + "] " + string2 + this.name;
        } else {
            string = string + "int[0, " + this.max + "] " + string2 + this.name;
        }
        outputStreamWriter.write(string);
    }

    public int getBits() {
        return this.bits;
    }

    public void setBits(int n) {
        this.bits = n;
    }

    @Override
    public String getDummyName(TAModel tAModel) {
        String string = "dummyinteger" + (this.constant ? "c" : "") + this.bits;
        if (tAModel.getGlobalVariable(string) == null) {
            TAInteger tAInteger = new TAInteger(string);
            tAInteger.setBits(this.bits);
            tAInteger.setConstant(this.constant);
            tAModel.addVariable(tAInteger);
        }
        return string;
    }

    public Expression getResetExpr() {
        BinaryExpression binaryExpression = new BinaryExpression((Expression)new VariableExpression(this), "0", "=");
        return binaryExpression;
    }

    @Override
    public TAArray asArray(int n) {
        TAArray tAArray = new TAArray(this.getName(), "int", "1", true, false);
        tAArray.addSizeOfDimension(n, 0);
        return tAArray;
    }
}

