/*
 * Decompiled with CFR 0.152.
 */
package de.tub.pes.state.model;

import de.tub.pes.state.model.Module;
import de.tub.pes.state.model.TAVariable;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.LinkedList;
import java.util.List;

public class TAFunction {
    private String name;
    private String type;
    private LinkedList<TAVariable> params;
    private LinkedList<TAVariable> locVars;

    public TAFunction(String string, String string2) {
        this.name = string;
        this.type = string2;
        this.params = new LinkedList();
        this.locVars = new LinkedList();
    }

    public String toString() {
        String string = this.type + " " + this.name + "(";
        for (TAVariable tAVariable : this.params) {
            string = string + tAVariable.createDeclarationString().replace(";" + Module.END_LINE, "");
            if (tAVariable == this.params.getLast()) continue;
            string = string + ", ";
        }
        string = string + ") {";
        for (TAVariable tAVariable : this.locVars) {
            string = string + "\t" + tAVariable.createDeclarationString();
        }
        string = string + Module.END_LINE;
        string = string + "}" + Module.END_LINE;
        return string;
    }

    public void print(OutputStreamWriter outputStreamWriter) throws IOException {
        String string = this.toString();
        outputStreamWriter.write(string);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public LinkedList<TAVariable> getParams() {
        return this.params;
    }

    public void setParams(LinkedList<TAVariable> linkedList) {
        this.params = linkedList;
    }

    public void addParam(TAVariable tAVariable) {
        this.params.addLast(tAVariable);
    }

    public List<TAVariable> getLocVars() {
        return this.locVars;
    }

    public void setLocVars(LinkedList<TAVariable> linkedList) {
        this.locVars = linkedList;
    }

    public void addLocVar(TAVariable tAVariable) {
        if (this.locVars.contains(tAVariable)) {
            System.out.println("WARNING: local variable " + tAVariable.getName() + " cannot be added more than once to function " + this.getName() + "!");
        } else {
            this.locVars.addLast(tAVariable);
        }
    }

    public TAFunction createCopy() {
        int n;
        TAFunction tAFunction = new TAFunction(this.name, this.type);
        for (n = 0; n < this.params.size(); ++n) {
            tAFunction.addParam(this.params.get(n).createCopy(""));
        }
        for (n = 0; n < this.locVars.size(); ++n) {
            tAFunction.addLocVar(this.locVars.get(n).createCopy(""));
        }
        return tAFunction;
    }
}

