/*
 * Decompiled with CFR 0.152.
 */
package de.tub.pes.state.model;

import de.tub.pes.state.model.Module;
import de.tub.pes.state.model.TAModel;
import de.tub.pes.state.model.TAVariable;
import java.io.IOException;
import java.io.OutputStreamWriter;

public class TAArray
extends TAVariable {
    private String name;
    private String type;
    private String dim;
    private boolean constant;
    private boolean constSize;
    private int[] size;
    private String initializer = null;

    public TAArray(String string, String string2, String string3, boolean bl, boolean bl2) {
        this.name = string;
        this.type = string2;
        this.dim = string3;
        this.constSize = bl;
        this.constant = bl2;
        if (bl) {
            this.size = new int[Integer.parseInt(string3)];
            for (int i = 0; i < this.size.length; ++i) {
                this.size[i] = 1;
            }
        }
    }

    @Override
    public TAVariable createCopy(String string) {
        TAArray tAArray = new TAArray(string + this.name, this.type, this.dim, this.constSize, this.constant);
        if (this.constSize) {
            for (int i = 0; i < this.size.length; ++i) {
                tAArray.addSizeOfDimension(this.size[i], i);
            }
        }
        return tAArray;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getDim() {
        return this.dim;
    }

    public void setDim(String string) {
        if (this.constSize) {
            int n;
            this.dim = string;
            int[] nArray = new int[Integer.parseInt(this.dim)];
            for (n = 0; n < nArray.length && n < this.size.length; ++n) {
                nArray[n] = this.size[n];
            }
            for (n = this.size.length; n < nArray.length; ++n) {
                nArray[n] = 1;
            }
            this.size = nArray;
        } else {
            System.out.println("ERROR: only the dimension of Arrays with fixed length may be altered. Ignoring new dimension " + this.dim + " for array " + this.name);
        }
    }

    public boolean isConstant() {
        return this.constant;
    }

    public void setConstant(boolean bl) {
        this.constant = bl;
    }

    public void setConstSize(boolean bl) {
        this.constSize = bl;
    }

    public boolean isConstSize() {
        return this.constSize;
    }

    public int[] getSize() {
        return this.size;
    }

    public void addSizeOfDimension(int n, int n2) {
        this.size[n2] = n;
    }

    public int getSizeOfDimension(int n) {
        return this.size[n];
    }

    public String getInitializer() {
        return this.initializer;
    }

    public void setInitializer(String string) {
        this.initializer = string;
    }

    @Override
    public void print(OutputStreamWriter outputStreamWriter) throws IOException {
        String string = this.createDeclarationString();
        outputStreamWriter.write(string);
    }

    @Override
    public String createDeclarationString() {
        String string = (this.constant ? "constant " : "") + this.type + " " + this.name;
        if (!this.constSize) {
            string = string + "[" + this.dim + "]";
        } else {
            for (int i = 0; i < Integer.parseInt(this.dim); ++i) {
                string = string + "[" + this.size[i] + "]";
            }
        }
        if (this.initializer != null) {
            string = string + " = " + this.initializer;
        }
        string = string + ";" + Module.END_LINE;
        return string;
    }

    @Override
    public void printAsParam(OutputStreamWriter outputStreamWriter) throws IOException {
        String string = this.type + " &amp;" + this.name;
        if (!this.constSize) {
            string = string + "[" + this.dim + "]";
        } else {
            for (int i = 0; i < Integer.parseInt(this.dim); ++i) {
                string = string + "[" + this.size[i] + "]";
            }
        }
        outputStreamWriter.write(string);
    }

    @Override
    public String getDummyName(TAModel tAModel) {
        String string = "dummyarray_" + this.type.replaceAll("[ \\[\\],", "x");
        if (!this.constSize) {
            string = string + "_" + this.dim;
        } else {
            for (int i = 0; i < Integer.parseInt(this.dim); ++i) {
                string = string + "_" + this.size[i];
                string = string + (this.constant ? "c" : "");
            }
        }
        if (tAModel.getGlobalVariable(string) != null) {
            TAArray tAArray = new TAArray(string, this.type, this.dim, this.constSize, this.constant);
            if (this.constSize) {
                for (int i = 0; i < Integer.parseInt(this.dim); ++i) {
                    tAArray.addSizeOfDimension(this.size[i], i);
                    tAModel.addVariable(tAArray);
                }
            }
        }
        return string;
    }

    @Override
    public TAArray asArray(int n) {
        TAArray tAArray = (TAArray)this.createCopy("");
        int n2 = Integer.parseInt(this.getDim()) + 1;
        if (this.isConstSize()) {
            tAArray.setDim(String.valueOf(n2));
            tAArray.addSizeOfDimension(n, n2 - 1);
        } else {
            System.out.println("ERROR: Array " + this.getName() + " has variable length! Cannot be converted into a multi-dimensional Array, as needed for multisocket support.");
        }
        return tAArray;
    }
}

