/*
 * Decompiled with CFR 0.152.
 */
package de.tub.pes.state.model;

import de.tub.pes.state.model.CClass;
import de.tub.pes.state.model.Constants;
import de.tub.pes.state.model.Function;
import de.tub.pes.state.model.Module;
import de.tub.pes.state.model.ModuleInstance;
import de.tub.pes.state.model.Peq;
import de.tub.pes.state.model.TAInteger;
import de.tub.pes.state.model.TAModel;
import de.tub.pes.state.model.TAStruct;
import de.tub.pes.state.model.TATypedef;
import de.tub.pes.state.model.TAVariable;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SCModel {
    private HashMap<String, Module> modules;
    private LinkedList<CClass> classes;
    private LinkedList<TATypedef> simpleTypes;
    private HashSet<String> knownTypes = new HashSet();
    private HashMap<String, ModuleInstance> instances;
    private HashMap<String, Peq> peqs;
    private HashMap<String, String> peqNotifications;
    private String testModule;
    private List<String> monitorModules;

    public SCModel() {
        this.modules = new HashMap();
        this.classes = new LinkedList();
        this.simpleTypes = new LinkedList();
        this.instances = new HashMap();
        this.monitorModules = new ArrayList<String>();
        this.peqs = new HashMap();
        this.peqNotifications = new HashMap();
    }

    public Module getModule(String string) {
        return this.modules.get(string);
    }

    public HashMap<String, Module> getModules() {
        return this.modules;
    }

    public void addModule(String string, Module module) {
        this.knownTypes.add(string);
        this.modules.put(string, module);
    }

    public CClass getClass(String string) {
        for (CClass cClass : this.classes) {
            if (!cClass.getName().equals(string)) continue;
            return cClass;
        }
        return null;
    }

    public LinkedList<CClass> getClasses() {
        return this.classes;
    }

    public void addClass(String string, CClass cClass) {
        this.knownTypes.add(string);
        this.classes.add(cClass);
    }

    public void addSimpleType(String string, TATypedef tATypedef) {
        this.knownTypes.add(string);
        this.simpleTypes.add(tATypedef);
    }

    public String getTestModule() {
        return this.testModule;
    }

    public List<String> getMonitorModules() {
        return this.monitorModules;
    }

    public ModuleInstance getInstance(String string) {
        return this.instances.get(string);
    }

    public HashMap<String, ModuleInstance> getInstances() {
        return this.instances;
    }

    public void addInstance(String string, ModuleInstance moduleInstance) {
        this.instances.put(string, moduleInstance);
    }

    public Peq getPeq(String string) {
        return this.peqs.get(string);
    }

    public void addPeq(String string, TAStruct tAStruct, TAModel tAModel) {
        String string2 = tAStruct.getType().getName();
        if (!this.peqs.containsKey(string2)) {
            Peq peq = new Peq(string, tAStruct, Constants.GLOBAL_PEQ_SIZE, this, tAModel);
            peq.create(tAModel);
            this.peqs.put(string2, peq);
        }
    }

    public void addPeqNotification(String string, String string2) {
        this.peqNotifications.put(string, string2);
    }

    public HashMap<String, String> getPeqNotifications() {
        return this.peqNotifications;
    }

    public void completeModules(TAModel tAModel) {
        for (CClass object : this.classes) {
            object.completeDefinition(this);
        }
        for (String string : this.modules.keySet()) {
            this.modules.get(string).completeDefinition(tAModel, this);
        }
    }

    public void create(TAModel tAModel) {
        Object object;
        for (CClass object2 : this.classes) {
            if (!object2.getMembers().isEmpty()) continue;
            object2.addMember(new TAInteger("dummy"));
        }
        tAModel.setStructs(this.classes);
        for (CClass cClass : this.classes) {
            for (Function function : cClass.getMethods()) {
                function.setConsumesTime(this.determineTimeConsumption(function, null));
            }
        }
        for (String string : this.instances.keySet()) {
            object = this.instances.get(string);
            Module module = ((ModuleInstance)object).getModule();
            for (Function function : module.getMethods()) {
                function.setConsumesTime(this.determineTimeConsumption(function, (ModuleInstance)object));
            }
        }
        for (String string : this.instances.keySet()) {
            object = this.instances.get(string);
            ((ModuleInstance)object).create("", new LinkedList<ModuleInstance>(), tAModel, this);
        }
    }

    public boolean determineTimeConsumption(Function function, ModuleInstance moduleInstance) {
        if (function.getTimingAnalyzed()) {
            return function.getConsumesTime();
        }
        function.setTimingAnalyzed(true);
        if (function.getConsumesTime()) {
            return true;
        }
        boolean bl = false;
        for (String string : function.getFunctionCalls()) {
            boolean bl2;
            block12: {
                block11: {
                    Object object;
                    Object object22;
                    bl2 = false;
                    if (!string.contains("#")) break block11;
                    if (moduleInstance == null) {
                        System.out.println("Warning: function " + function.getName() + " uses dereferenced function call " + string + ". This is not supported for class methods.");
                    }
                    int n = string.lastIndexOf("#");
                    String string2 = string.substring(n + 1);
                    String string3 = string.substring(0, n);
                    for (TAVariable tAVariable : moduleInstance.getModule().getSimpleMembers()) {
                        if (!(tAVariable instanceof TAStruct) || !tAVariable.getName().equals(string3) || (object22 = ((TAStruct)tAVariable).getType().getMethod(string2)) == null) continue;
                        bl2 = true;
                        bl = bl || this.determineTimeConsumption((Function)object22, moduleInstance);
                    }
                    if (moduleInstance.getModule().getPorts().containsKey(string3)) {
                        object = this.getModule(moduleInstance.getModule().getPorts().get(string3));
                        for (Object object22 : ((Module)object).getMethods()) {
                            if (!((Function)object22).getName().equals(string2)) continue;
                            bl2 = true;
                            bl = bl || this.determineTimeConsumption((Function)object22, moduleInstance);
                        }
                    }
                    if (moduleInstance.getModule().getSockets().containsKey(string3)) {
                        for (String string4 : moduleInstance.getSocketConnections().get(string3)) {
                            object22 = this.getInstance(string4);
                            Module module = ((ModuleInstance)object22).getModule();
                            for (Function function2 : module.getMethods()) {
                                if (!function2.getName().equals(string2)) continue;
                                bl2 = true;
                                bl = bl || this.determineTimeConsumption(function2, (ModuleInstance)object22);
                            }
                        }
                    }
                    if (!moduleInstance.getModule().getPeqs().containsKey(string3)) break block12;
                    object = moduleInstance.getModule().getPeq(string3);
                    if (!string2.equals("notify")) break block12;
                    Function function3 = ((Peq)object).getCallbackFunction();
                    bl2 = true;
                    bl = bl || this.determineTimeConsumption(function3, moduleInstance);
                    break block12;
                }
                for (Function function4 : moduleInstance.getModule().getMethods()) {
                    if (!function4.getName().equals(string)) continue;
                    bl2 = true;
                    bl = bl || this.determineTimeConsumption(function4, moduleInstance);
                }
            }
            if (bl2) continue;
            System.out.println("I couldn't find the target of function call " + string + " in function " + function + " of module instance " + moduleInstance.getName());
            return true;
        }
        return bl;
    }

    public int countThreads() {
        int n = 0;
        for (Map.Entry<String, ModuleInstance> entry : this.instances.entrySet()) {
            n += entry.getValue().getModule().countThreads();
        }
        return n;
    }

    public void readTB(String string) {
        if (string != null) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
                boolean bl = false;
                boolean bl2 = false;
                while (bufferedReader.ready()) {
                    String string2 = bufferedReader.readLine();
                    if (bl) {
                        this.testModule = string2;
                        bl = false;
                    } else if (bl2) {
                        this.monitorModules.add(string2);
                        System.out.println("Monitor: " + string2);
                    }
                    if (string2.startsWith("# input")) {
                        bl = true;
                        continue;
                    }
                    if (!string2.startsWith("# output")) continue;
                    bl = false;
                    bl2 = true;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("Can not find testbench configuration file " + string + ". Skipping.");
                return;
            }
            catch (IOException iOException) {
                System.out.println("Can not find testbench configuration file " + string + ". Skipping.");
                return;
            }
        }
    }

    public boolean isKnownType(String string) {
        return this.knownTypes.contains(string);
    }

    public TATypedef getSimpleType(String string) {
        for (TATypedef tATypedef : this.simpleTypes) {
            if (!tATypedef.getName().equals(string)) continue;
            return tATypedef;
        }
        return null;
    }
}

