/*
 * Decompiled with CFR 0.152.
 */
package de.tub.pes.state.model;

import de.tub.pes.state.model.Constants;
import de.tub.pes.state.model.Function;
import de.tub.pes.state.model.SCModel;
import de.tub.pes.state.model.TAChannel;
import de.tub.pes.state.model.TAClock;
import de.tub.pes.state.model.TAInteger;
import de.tub.pes.state.model.TALocation;
import de.tub.pes.state.model.TAModel;
import de.tub.pes.state.model.TAStruct;
import de.tub.pes.state.model.TATemplate;
import de.tub.pes.state.model.TATransition;
import de.tub.pes.state.model.TAVariable;
import de.tub.pes.state.model.expression.BinaryExpression;
import de.tub.pes.state.model.expression.Expression;
import de.tub.pes.state.model.expression.IncDecExpression;
import de.tub.pes.state.model.expression.SendReceiveExpression;
import java.util.LinkedList;
import java.util.List;

public class Peq {
    private String name;
    private TAStruct dataType;
    private LinkedList<TAVariable> globalVars = new LinkedList();
    private int size;
    private Function callbackFunction = null;
    private Function notifyFunction = null;
    private TATemplate notifyTemplate = null;
    private Function fetchFunction = null;
    private TATemplate fetchTemplate = null;
    private String CTRL;
    private String NOTIFY;
    private String NOTIFY_T;
    private String PEQ_CB_CTRL;
    private String PEQ_CB_PARAM_PHASE;
    private String PEQ_CB_PARAM_TRANS;
    private String FETCH_CTRL;
    private String FETCH_PARAM_PHASE;
    private String FETCH_PARAM_TRANS;
    private String WAIT;
    private String PAYLOAD;
    private String PHASE;
    private String DELAY;

    public Peq(String string, TAStruct tAStruct, int n, SCModel sCModel, TAModel tAModel) {
        this.name = string;
        this.dataType = tAStruct;
        this.size = n;
    }

    public Peq(Peq peq) {
        this.callbackFunction = peq.callbackFunction;
        this.dataType = peq.dataType;
        this.fetchFunction = peq.fetchFunction;
        this.fetchTemplate = peq.fetchTemplate;
        this.globalVars = peq.globalVars;
        this.name = peq.name;
        this.notifyFunction = peq.notifyFunction;
        this.notifyTemplate = peq.notifyTemplate;
        this.size = peq.size;
    }

    public void create(TAModel tAModel) {
        this.generateNotifyFunction(tAModel);
        this.generateFetchFunction(tAModel);
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public int getSize() {
        return this.size;
    }

    public List<TAVariable> getAllVisibleParameters() {
        LinkedList<TAVariable> linkedList = new LinkedList<TAVariable>();
        linkedList.addAll(this.notifyFunction.getParams());
        return linkedList;
    }

    public Function getCallbackFunction() {
        return this.callbackFunction;
    }

    public void setCallbackFunction(Function function) {
        this.callbackFunction = function;
    }

    public Function getNotifyFunction() {
        return this.notifyFunction;
    }

    public Function getFetchFunction() {
        return this.fetchFunction;
    }

    private void generateNotifyFunction(TAModel tAModel) {
        this.PEQ_CB_CTRL = Constants.createDelimitedString("peq_cb", "ctrl");
        this.PEQ_CB_PARAM_PHASE = Constants.createDelimitedString("peq_cb", "param", "phase");
        this.PEQ_CB_PARAM_TRANS = Constants.createDelimitedString("peq_cb", "param", "tran");
        this.FETCH_CTRL = Constants.createDelimitedString("peq_fetch", "ctrl");
        this.FETCH_PARAM_PHASE = Constants.createDelimitedString("peq_fetch", "param", "phase");
        this.FETCH_PARAM_TRANS = Constants.createDelimitedString("peq_fetch", "param", "tran");
        this.WAIT = "wait";
        this.NOTIFY = "notify";
        this.NOTIFY_T = Constants.createDelimitedString("notify", "t");
        this.notifyFunction = new Function("peq_notify");
        this.notifyFunction.addParam(this.dataType.getType().createStruct("peq_notify#param#trans"));
        this.notifyFunction.addParam(new TAChannel(this.notifyFunction.getName() + "#" + "ctrl", false));
        this.notifyFunction.addParam(new TAInteger("peq_notify#param#phase"));
        this.notifyFunction.addParam(new TAInteger("peq_notify#param#delay"));
        this.notifyTemplate = new TATemplate(Constants.createDelimitedString(this.notifyFunction.getName(), this.dataType.getType().getName()));
        this.notifyTemplate.addParameter(new TAChannel(this.notifyFunction.getName() + "#" + "ctrl", false));
        this.notifyTemplate.addParameter(this.dataType.getType().createStruct("peq_notify#param#trans"));
        this.notifyTemplate.addParameter(new TAInteger("peq_notify#param#phase"));
        this.notifyTemplate.addParameter(new TAInteger("peq_notify#param#delay"));
        this.notifyTemplate.addParameter(new TAChannel(this.FETCH_CTRL, false));
        this.notifyTemplate.addParameter(this.dataType.getType().createStruct(this.FETCH_PARAM_TRANS));
        this.notifyTemplate.addParameter(new TAInteger(this.FETCH_PARAM_PHASE));
        this.notifyTemplate.addLocalVar(this.dataType.getType().createStruct("payload"));
        this.notifyTemplate.addLocalVar(new TAInteger("phase"));
        this.notifyTemplate.addLocalVar(new TAInteger("delay"));
        this.notifyTemplate.addLocalVar(new TAClock("c"));
        TALocation tALocation = new TALocation();
        tALocation.setName("init_location");
        TALocation tALocation2 = new TALocation();
        TALocation tALocation3 = new TALocation();
        TALocation tALocation4 = new TALocation();
        TALocation tALocation5 = new TALocation();
        TALocation tALocation6 = new TALocation();
        tALocation2.setInvariant2(new BinaryExpression("c", "delay", "<="));
        tALocation3.setCommitted(true);
        tALocation4.setCommitted(true);
        tALocation6.setUrgent(true);
        TATransition tATransition = new TATransition(tALocation, tALocation2);
        TATransition tATransition2 = new TATransition(tALocation2, tALocation3);
        TATransition tATransition3 = new TATransition(tALocation3, tALocation2);
        TATransition tATransition4 = new TATransition(tALocation3, tALocation4);
        TATransition tATransition5 = new TATransition(tALocation2, tALocation4);
        TATransition tATransition6 = new TATransition(tALocation2, tALocation4);
        TATransition tATransition7 = new TATransition(tALocation4, tALocation5);
        TATransition tATransition8 = new TATransition(tALocation5, tALocation6);
        TATransition tATransition9 = new TATransition(tALocation6, tALocation);
        tATransition.setSync(new SendReceiveExpression(this.notifyFunction.getName() + "#" + "ctrl", false));
        tATransition.addUpdateExpression(new BinaryExpression("payload", "peq_notify#param#trans", "="));
        tATransition.addUpdateExpression(new BinaryExpression("phase", "peq_notify#param#phase", "="));
        tATransition.addUpdateExpression(new BinaryExpression("delay", "peq_notify#param#delay", "="));
        tATransition.addUpdateExpression(new BinaryExpression("c", "0", "="));
        tATransition2.setSync(new SendReceiveExpression("advancetime", false));
        tATransition2.setGuard(new BinaryExpression("delay", "0", "!="));
        tATransition3.setGuard(new BinaryExpression("c", "delay", "<"));
        tATransition4.setGuard(new BinaryExpression("c", "delay", "=="));
        tATransition5.setSync(new SendReceiveExpression("deltadelay", false));
        tATransition5.setGuard(new BinaryExpression("delay", "0", "=="));
        tATransition6.setSync(new SendReceiveExpression("advancetime", true));
        tATransition6.setGuard(new BinaryExpression((Expression)new BinaryExpression("delay", "0", "!="), (Expression)new BinaryExpression("c", "delay", "=="), "&&"));
        tATransition7.addUpdateExpression(new IncDecExpression("readyprocs", true, false));
        tATransition8.setSync(new SendReceiveExpression("activate", false));
        tATransition9.setSync(new SendReceiveExpression(this.FETCH_CTRL, true));
        tATransition9.addUpdateExpression(new BinaryExpression(this.FETCH_PARAM_TRANS, "payload", "="));
        tATransition9.addUpdateExpression(new BinaryExpression(this.FETCH_PARAM_PHASE, "phase", "="));
        tATransition9.addUpdateExpression(new BinaryExpression("payload", this.dataType.getType().getEmptyElementString(), "="));
        tATransition9.addUpdateExpression(new BinaryExpression("phase", "0", "="));
        tATransition9.addUpdateExpression(new BinaryExpression("delay", "0", "="));
        this.notifyTemplate.addLocation(tALocation);
        this.notifyTemplate.addLocation(tALocation2);
        this.notifyTemplate.addLocation(tALocation3);
        this.notifyTemplate.addLocation(tALocation4);
        this.notifyTemplate.addLocation(tALocation5);
        this.notifyTemplate.addLocation(tALocation6);
        this.notifyTemplate.addTransition(tATransition);
        this.notifyTemplate.addTransition(tATransition2);
        this.notifyTemplate.addTransition(tATransition3);
        this.notifyTemplate.addTransition(tATransition4);
        this.notifyTemplate.addTransition(tATransition5);
        this.notifyTemplate.addTransition(tATransition6);
        this.notifyTemplate.addTransition(tATransition7);
        this.notifyTemplate.addTransition(tATransition8);
        this.notifyTemplate.addTransition(tATransition9);
        this.notifyTemplate.setInitLocation(tALocation);
        tAModel.addTemplate(this.notifyTemplate);
        this.notifyFunction.setTemplateName(this.notifyTemplate.getName());
    }

    private void generateFetchFunction(TAModel tAModel) {
        this.fetchFunction = new Function("peq_fetch");
        this.fetchFunction.addParam(new TAChannel(this.FETCH_CTRL, false));
        this.fetchFunction.addParam(this.dataType.getType().createStruct(this.FETCH_PARAM_TRANS));
        this.fetchFunction.addParam(new TAInteger(this.FETCH_PARAM_PHASE));
        this.fetchTemplate = new TATemplate(Constants.createDelimitedString(this.fetchFunction.getName(), this.dataType.getType().getName()));
        this.fetchTemplate.addParameter(new TAChannel(this.FETCH_CTRL, false));
        this.fetchTemplate.addParameter(this.dataType.getType().createStruct(this.FETCH_PARAM_TRANS));
        this.fetchTemplate.addParameter(new TAInteger(this.FETCH_PARAM_PHASE));
        this.fetchTemplate.addParameter(new TAChannel(this.PEQ_CB_CTRL, false));
        this.fetchTemplate.addParameter(this.dataType.getType().createStruct(this.PEQ_CB_PARAM_TRANS));
        this.fetchTemplate.addParameter(new TAInteger(this.PEQ_CB_PARAM_PHASE));
        TALocation tALocation = new TALocation();
        TALocation tALocation2 = new TALocation();
        TALocation tALocation3 = new TALocation();
        TALocation tALocation4 = new TALocation();
        tALocation2.setUrgent(true);
        tALocation4.setUrgent(true);
        TATransition tATransition = new TATransition(tALocation, tALocation2);
        TATransition tATransition2 = new TATransition(tALocation2, tALocation3);
        TATransition tATransition3 = new TATransition(tALocation3, tALocation4);
        TATransition tATransition4 = new TATransition(tALocation4, tALocation);
        tATransition.setSync(new SendReceiveExpression(this.FETCH_CTRL, false));
        tATransition2.setSync(new SendReceiveExpression(this.PEQ_CB_CTRL, true));
        tATransition2.addUpdateExpression(new BinaryExpression(this.PEQ_CB_PARAM_TRANS, this.FETCH_PARAM_TRANS, "="));
        tATransition2.addUpdateExpression(new BinaryExpression(this.PEQ_CB_PARAM_PHASE, this.FETCH_PARAM_PHASE, "="));
        tATransition3.setSync(new SendReceiveExpression(this.PEQ_CB_CTRL, false));
        tATransition4.setSync(new SendReceiveExpression("deactivate", true));
        tATransition4.addUpdateExpression(new IncDecExpression("readyprocs", false, false));
        this.fetchTemplate.addLocation(tALocation);
        this.fetchTemplate.addLocation(tALocation2);
        this.fetchTemplate.addLocation(tALocation3);
        this.fetchTemplate.addLocation(tALocation4);
        this.fetchTemplate.addTransition(tATransition);
        this.fetchTemplate.addTransition(tATransition2);
        this.fetchTemplate.addTransition(tATransition3);
        this.fetchTemplate.addTransition(tATransition4);
        this.fetchTemplate.setInitLocation(tALocation);
        tAModel.addTemplate(this.fetchTemplate);
        this.fetchFunction.setTemplateName(this.fetchTemplate.getName());
    }

    public String toString() {
        return this.name;
    }

    public Peq createInstance(String string, SCModel sCModel, TAModel tAModel) {
        Peq peq = new Peq(string, this.dataType, this.size, sCModel, tAModel);
        if (this.callbackFunction != null) {
            peq.callbackFunction = this.callbackFunction.createCopy();
        }
        peq.globalVars = this.globalVars;
        peq.notifyFunction = this.notifyFunction;
        peq.notifyTemplate = this.notifyTemplate;
        peq.fetchFunction = this.fetchFunction;
        peq.fetchTemplate = this.fetchTemplate;
        return peq;
    }

    public LinkedList<TAVariable> getGlobalVariables() {
        return this.globalVars;
    }

    public TATemplate getNotifyTemplate() {
        return this.notifyTemplate;
    }

    public TATemplate getFetchTemplate() {
        return this.fetchTemplate;
    }
}

