/*
 * Decompiled with CFR 0.152.
 */
package de.tub.pes.state.model;

import de.tub.pes.state.model.Constructor;
import de.tub.pes.state.model.Function;
import de.tub.pes.state.model.ModuleInstance;
import de.tub.pes.state.model.Peq;
import de.tub.pes.state.model.SCModel;
import de.tub.pes.state.model.TAChannel;
import de.tub.pes.state.model.TAInteger;
import de.tub.pes.state.model.TALocation;
import de.tub.pes.state.model.TAModel;
import de.tub.pes.state.model.TAStruct;
import de.tub.pes.state.model.TATemplate;
import de.tub.pes.state.model.TATransition;
import de.tub.pes.state.model.TAVariable;
import de.tub.pes.state.model.Thread;
import de.tub.pes.state.model.expression.SendReceiveExpression;
import de.tub.pes.state.util.ListUtils;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class Module {
    private String name;
    private boolean isSCModule;
    private boolean primChannel;
    private boolean testModule;
    private boolean monitorModule;
    private LinkedList<Thread> threads = null;
    private Map<String, String> ports = null;
    private Map<String, String> sockets = null;
    private Map<String, String> socketBindings = null;
    private Map<String, Integer> maxSocketConnections = null;
    private Map<String, Peq> peqs = null;
    private LinkedList<String> events;
    private String defaultEvent = null;
    private LinkedList<TAVariable> simpleMembers;
    private LinkedList<Function> methods;
    private Constructor constructor = null;
    private LinkedList<ModuleInstance> complexMembers;
    private LinkedList<ModuleInstance> localInstances;
    private LinkedList<TATemplate> templates;
    private static final String DIV = "#";
    public static final String END_LINE = System.getProperty("line.separator");

    public Module(String string, boolean bl) {
        this.name = string;
        this.simpleMembers = new LinkedList();
        this.methods = new LinkedList();
        this.complexMembers = new LinkedList();
        this.localInstances = new LinkedList();
        this.templates = new LinkedList();
        this.events = new LinkedList();
        this.ports = new HashMap<String, String>();
        this.sockets = new HashMap<String, String>();
        this.socketBindings = new HashMap<String, String>();
        this.maxSocketConnections = new HashMap<String, Integer>();
        this.peqs = new HashMap<String, Peq>();
        if (bl) {
            this.threads = new LinkedList();
            this.isSCModule = bl;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean isTestModule() {
        return this.testModule;
    }

    public void setTestModule() {
        this.testModule = true;
    }

    public boolean isMonitorModule() {
        return this.monitorModule;
    }

    public void setMonitorModule() {
        this.monitorModule = true;
    }

    public void addThread(Thread thread) {
        this.threads.addLast(thread);
    }

    public List<Thread> getThreads() {
        return this.threads;
    }

    public Map<String, String> getPorts() {
        return this.ports;
    }

    public void addPort(String string, String string2) {
        this.ports.put(string, string2);
    }

    public void setPorts(Map<String, String> map) {
        this.ports = map;
    }

    public Map<String, String> getSockets() {
        return this.sockets;
    }

    public void addSocket(String string, String string2) {
        this.sockets.put(string, string2);
    }

    public void setSocketBindings(Map<String, String> map) {
        this.socketBindings = map;
    }

    public Map<String, String> getSocketBindings() {
        return this.socketBindings;
    }

    public void addSocketBinding(String string, String string2) {
        this.socketBindings.put(string, string2);
    }

    public void setMaxSocketConnection(String string, int n) {
        if (!this.maxSocketConnections.containsKey(string) || this.maxSocketConnections.get(string) < n) {
            this.maxSocketConnections.put(string, n);
        }
    }

    public Map<String, Integer> getMaxSocketConnections() {
        return this.maxSocketConnections;
    }

    public int getMaxSocketConnection(String string) {
        return this.maxSocketConnections.get(string);
    }

    public void setMaxSocketConnections(Map<String, Integer> map) {
        this.maxSocketConnections = map;
    }

    public void setSockets(Map<String, String> map) {
        this.sockets = map;
    }

    public void addEvent(String string) {
        this.events.addLast(string);
    }

    public List<String> getEvents() {
        return this.events;
    }

    public void addSimpleMember(TAVariable tAVariable) {
        this.simpleMembers.addLast(tAVariable);
    }

    public List<TAVariable> getSimpleMembers() {
        return this.simpleMembers;
    }

    public void addMethod(Function function) {
        this.methods.addLast(function);
    }

    public List<Function> getMethods() {
        return this.methods;
    }

    public Function getMethodByName(String string) {
        for (Function function : this.methods) {
            if (!function.getName().equals(string)) continue;
            return function;
        }
        return null;
    }

    public void addTemplate(TATemplate tATemplate) {
        this.templates.addLast(tATemplate);
    }

    public TATemplate getTemplate(String string) {
        for (TATemplate tATemplate : this.templates) {
            if (!string.equals(tATemplate.getName())) continue;
            return tATemplate;
        }
        return null;
    }

    public List<TATemplate> getTemplates() {
        return this.templates;
    }

    public void setDefaultEvent(String string) {
        this.defaultEvent = string;
    }

    public String getDefaultEvent() {
        return this.defaultEvent;
    }

    public boolean isSCModule() {
        return this.isSCModule;
    }

    public void setSCModule(boolean bl) {
        this.isSCModule = bl;
    }

    public Constructor getConstructor() {
        return this.constructor;
    }

    public void setConstructor(Constructor constructor) {
        this.constructor = constructor;
    }

    public boolean isPrimChannel() {
        return this.primChannel;
    }

    public void setPrimChannel(boolean bl) {
        this.primChannel = bl;
    }

    public LinkedList<ModuleInstance> getComplexMembers() {
        return this.complexMembers;
    }

    public void addComplexMember(String string, Module module) {
        this.complexMembers.add(new ModuleInstance(string, module));
    }

    public void addComplexMember(ModuleInstance moduleInstance) {
        this.complexMembers.add(moduleInstance);
    }

    public void setComplexMembers(LinkedList<ModuleInstance> linkedList) {
        this.complexMembers = linkedList;
    }

    public LinkedList<ModuleInstance> getLocalInstances() {
        return this.localInstances;
    }

    public void addLocalInstance(String string, Module module) {
        this.localInstances.add(new ModuleInstance(string, module));
    }

    public void setLocalInstances(LinkedList<ModuleInstance> linkedList) {
        this.localInstances = linkedList;
    }

    public void addPeq(String string, Peq peq, TAModel tAModel) {
        String string2 = this.getName() + DIV + string;
        Peq peq2 = new Peq(peq);
        if (tAModel.getPeqSizeMap().containsKey(string2)) {
            peq2.setSize(tAModel.getPeqSizeMap().get(string2));
        }
        this.peqs.put(string, peq2);
    }

    public Peq getPeq(String string) {
        return this.peqs.get(string);
    }

    public Map<String, Peq> getPeqs() {
        return this.peqs;
    }

    public void setPeqs(HashMap<String, Peq> hashMap) {
        this.peqs = hashMap;
    }

    public List<TAVariable> listOfVarsAsArrays(List<TAVariable> list, int n) {
        LinkedList<TAVariable> linkedList = new LinkedList<TAVariable>();
        for (TAVariable tAVariable : list) {
            linkedList.add(tAVariable.asArray(n));
        }
        return linkedList;
    }

    public List<TAVariable> getAllVisibleMembers() {
        LinkedList<TAVariable> linkedList = new LinkedList<TAVariable>();
        ListUtils<TAVariable> listUtils = new ListUtils<TAVariable>();
        listUtils.addListToList(linkedList, this.simpleMembers);
        for (Function object : this.methods) {
            listUtils.addListToList(linkedList, object.getAsTAVariables());
        }
        for (ModuleInstance moduleInstance : this.complexMembers) {
            List<TAVariable> list = moduleInstance.getModule().getAllVisibleMembers();
            for (TAVariable tAVariable : list) {
                linkedList.add(tAVariable.createCopy(moduleInstance.getName() + DIV));
            }
        }
        return linkedList;
    }

    public List<TAVariable> getElements() {
        LinkedList<TAVariable> linkedList = new LinkedList<TAVariable>();
        ListUtils<TAVariable> listUtils = new ListUtils<TAVariable>();
        listUtils.addListToList(linkedList, this.simpleMembers);
        for (ModuleInstance moduleInstance : this.complexMembers) {
            List<TAVariable> list = moduleInstance.getModule().getElements();
            for (TAVariable tAVariable : list) {
                linkedList.add(tAVariable.createCopy(moduleInstance.getName() + DIV));
            }
        }
        return linkedList;
    }

    public boolean isEvent(String string, SCModel sCModel) {
        if (this.events.contains(string)) {
            return true;
        }
        int n = string.indexOf(DIV);
        if (n > 0) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + DIV.length());
            ModuleInstance moduleInstance = this.getComplexMember(string2);
            if (moduleInstance != null) {
                return moduleInstance.getModule().isEvent(string3, sCModel);
            }
            String string4 = this.ports.get(string2);
            if (string4 != null) {
                return sCModel.getModule(string4).isEvent(string3, sCModel);
            }
        }
        return false;
    }

    public boolean isPeq(String string, SCModel sCModel) {
        for (String string2 : this.peqs.keySet()) {
            if (!string2.equals(string)) continue;
            return true;
        }
        int n = string.indexOf(DIV);
        if (n > 0) {
            String string2;
            string2 = string.substring(0, n);
            String string3 = string.substring(n + DIV.length());
            ModuleInstance moduleInstance = this.getComplexMember(string2);
            if (moduleInstance != null) {
                return moduleInstance.getModule().isPeq(string3, sCModel);
            }
            String string4 = this.ports.get(string2);
            if (string4 != null) {
                return sCModel.getModule(string4).isPeq(string3, sCModel);
            }
        }
        return false;
    }

    public boolean isSimpleMember(String string, Stack<String> stack) {
        if (stack == null || stack.size() == 0) {
            for (TAVariable tAVariable : this.simpleMembers) {
                if (!tAVariable.getName().equals(string)) continue;
                return true;
            }
        } else {
            ModuleInstance moduleInstance = this.getComplexMember(stack.pop());
            if (moduleInstance != null) {
                return moduleInstance.getModule().isSimpleMember(string, stack);
            }
        }
        return false;
    }

    public ModuleInstance getComplexMember(String string) {
        for (ModuleInstance moduleInstance : this.complexMembers) {
            if (!moduleInstance.getName().equals(string)) continue;
            return moduleInstance;
        }
        return null;
    }

    public TAVariable getMember(String string) {
        if (!string.contains(".")) {
            for (TAVariable tAVariable : this.simpleMembers) {
                if (!tAVariable.getName().equals(string)) continue;
                return tAVariable;
            }
        }
        return null;
    }

    public Function createMethod(TAModel tAModel, String string) {
        Function function = new Function(string, this.getName() + DIV + string);
        this.methods.add(function);
        TATemplate tATemplate = new TATemplate(this.getName() + DIV + string);
        if (this.monitorModule) {
            tATemplate.setMonitorTemplate();
        }
        if (this.testModule) {
            tATemplate.setTestTemplate();
        }
        this.templates.add(tATemplate);
        tAModel.addTemplate(tATemplate);
        return function;
    }

    public TATemplate findMethodTemplate(TAModel tAModel, String string) {
        String string2 = this.getName() + DIV + string;
        return tAModel.getTemplates().get(string2);
    }

    public Function findMethod(String string, String string2) {
        Object object;
        if (string2 == null || string2.length() == 0) {
            object = this.methods.iterator();
            while (object.hasNext()) {
                Function function = (Function)object.next();
                if (!function.getName().equals(string)) continue;
                return function;
            }
        }
        if ((object = this.findMethodInModuleMap(this.complexMembers, string, string2)) != null) {
            return object;
        }
        return null;
    }

    private Function findMethodInModuleMap(List<ModuleInstance> list, String string, String string2) {
        for (ModuleInstance moduleInstance : list) {
            String string3 = moduleInstance.getName();
            if (string2.indexOf(string3 + DIV) != 0) continue;
            return moduleInstance.getModule().findMethod(string, string2.substring(string3.length() + DIV.length()));
        }
        return null;
    }

    public void completeDefinition(TAModel tAModel, SCModel sCModel) {
        this.createTemplateHeader(sCModel);
        if (this.isSCModule) {
            this.createSensitivityTemplates(tAModel);
        }
    }

    private void createSensitivityTemplates(TAModel tAModel) {
        for (int i = 0; i < this.threads.size(); ++i) {
            Thread thread = this.threads.get(i);
            TATemplate tATemplate = new TATemplate(this.getName() + DIV + "thread" + i + DIV + "sensitive" + "Temp");
            TALocation tALocation = new TALocation();
            tATemplate.addLocation(tALocation);
            tATemplate.setInitLocation(tALocation);
            TALocation tALocation2 = new TALocation();
            tALocation2.setCommitted(true);
            tATemplate.addLocation(tALocation2);
            tATemplate.addTransition(new TATransition(tALocation2, tALocation, new SendReceiveExpression("sensitive", true)));
            tATemplate.addParameter(new TAChannel("sensitive", true));
            for (String string : thread.getSensitivityList()) {
                tATemplate.addParameter(new TAChannel(string, true));
                tATemplate.addTransition(new TATransition(tALocation, tALocation2, new SendReceiveExpression(string, false)));
            }
            tAModel.addTemplate(tATemplate);
        }
    }

    public void createTemplateHeader(SCModel sCModel) {
        List<TAVariable> list;
        HashMap<String, Module> hashMap = sCModel.getModules();
        LinkedList<TAVariable> linkedList = new LinkedList<TAVariable>();
        ListUtils<TAVariable> listUtils = new ListUtils<TAVariable>();
        linkedList.add(new TAChannel("sensitive", true));
        linkedList.add(new TAChannel("timeoutevent#wait", true));
        linkedList.add(new TAChannel("timeoutevent#notify", false));
        linkedList.add(new TAChannel("timeoutevent#notify_imm", false));
        linkedList.add(new TAInteger("timeoutevent#notify_t"));
        if (this.isSCModule) {
            for (String object : this.ports.keySet()) {
                list = hashMap.get(this.ports.get(object)) != null ? ((Module)hashMap.get(this.ports.get(object))).getAllVisibleMembers() : sCModel.getClass(this.ports.get(object)).getAllVisibleMembers();
                this.addPrefixedList(linkedList, list, object + DIV);
            }
            for (String string : this.sockets.keySet()) {
                list = this.sockets.get(string);
                String string2 = string + DIV;
                if (this.maxSocketConnections.containsKey(string) && this.maxSocketConnections.get(string) > 0) {
                    this.addPrefixedList(linkedList, this.listOfVarsAsArrays(((Module)hashMap.get(list)).getAllVisibleMembers(), this.getMaxSocketConnection(string) + 1), string2);
                    continue;
                }
                this.addPrefixedList(linkedList, ((Module)hashMap.get(list)).getAllVisibleMembers(), string2);
            }
        }
        for (String string : this.peqs.keySet()) {
            this.addPrefixedList(linkedList, this.peqs.get(string).getAllVisibleParameters(), string + DIV);
        }
        for (TAVariable tAVariable : this.simpleMembers) {
            linkedList.add(tAVariable.createCopy(""));
            if (!(tAVariable instanceof TAStruct)) continue;
            list = (TAStruct)tAVariable;
            for (Function function : ((TAStruct)((Object)list)).getType().getMethods()) {
                for (TAVariable tAVariable2 : function.getAsTAVariables()) {
                    linkedList.add(tAVariable2.createCopy(tAVariable.getName() + DIV));
                }
            }
        }
        for (Function function : this.methods) {
            listUtils.addListToList(linkedList, function.getAsTAVariables());
        }
        for (ModuleInstance moduleInstance : this.complexMembers) {
            this.addPrefixedList(linkedList, moduleInstance.getModule().getAllVisibleMembers(), moduleInstance.getName() + DIV);
        }
        for (TATemplate tATemplate : this.templates) {
            tATemplate.setParameters(linkedList);
        }
    }

    private void addPrefixedList(List<TAVariable> list, List<TAVariable> list2, String string) {
        for (TAVariable tAVariable : list2) {
            list.add(tAVariable.createCopy(string));
        }
    }

    public int countThreads() {
        int n = 0;
        if (this.threads != null) {
            for (Thread object : this.threads) {
                if (!object.initializes()) continue;
                ++n;
            }
        }
        for (ModuleInstance moduleInstance : this.complexMembers) {
            n += moduleInstance.getModule().countThreads();
        }
        return n;
    }

    public boolean isThread(String string) {
        if (this.threads != null) {
            for (Thread thread : this.threads) {
                if (!thread.getFunction().equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public Module createCopy(String string, TAModel tAModel, SCModel sCModel) {
        Object object;
        Module module = new Module(this.name + string, this.isSCModule);
        module.setPrimChannel(this.primChannel);
        for (Thread object2 : this.threads) {
            module.addThread(object2.createCopy());
        }
        module.setPorts((HashMap)((HashMap)this.ports).clone());
        module.setSockets((HashMap)((HashMap)this.sockets).clone());
        module.setSocketBindings((HashMap)((HashMap)this.socketBindings).clone());
        module.setMaxSocketConnections((HashMap)((HashMap)this.maxSocketConnections).clone());
        module.setPeqs((HashMap)((HashMap)this.peqs).clone());
        for (String string2 : this.events) {
            module.addEvent(string2);
        }
        module.setDefaultEvent(this.defaultEvent);
        for (TAVariable tAVariable : this.simpleMembers) {
            module.addSimpleMember(tAVariable.createCopy(""));
        }
        for (Function function : this.methods) {
            object = function.createCopy();
            ((Function)object).setTemplateName(function.getTemplateName().replaceFirst(this.name, this.name + string));
            module.addMethod((Function)object);
        }
        if (this.constructor != null) {
            module.setConstructor(this.constructor.createCopy());
        }
        module.setComplexMembers((LinkedList)this.complexMembers.clone());
        for (TATemplate tATemplate : this.templates) {
            object = tATemplate.createCopy(tATemplate.getName().replaceFirst(this.name, this.name + string));
            tAModel.addTemplate((TATemplate)object);
            module.addTemplate((TATemplate)object);
        }
        this.createTemplateHeader(sCModel);
        return module;
    }

    public String toString() {
        return this.name;
    }
}

