/*
 * Decompiled with CFR 0.152.
 */
package de.tub.pes.state.model;

import de.tub.pes.state.model.TAChannel;
import de.tub.pes.state.model.TAVariable;
import java.util.LinkedList;
import java.util.List;

public class Function {
    protected String name;
    protected LinkedList<TAVariable> params;
    protected TAVariable returnType = null;
    protected String templateName = null;
    protected boolean consumesTime;
    protected boolean timingAnalyzed;
    protected boolean usesWait;
    protected boolean isCalled;
    protected LinkedList<String> functionCalls;

    public Function(String string) {
        this.name = string;
        this.params = new LinkedList();
        this.consumesTime = false;
        this.usesWait = false;
        this.isCalled = false;
        this.functionCalls = new LinkedList();
    }

    public Function(String string, String string2) {
        this.name = string;
        this.templateName = string2;
        this.params = new LinkedList();
        this.consumesTime = false;
        this.usesWait = false;
        this.isCalled = false;
        this.functionCalls = new LinkedList();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String string) {
        this.templateName = string;
    }

    public List<TAVariable> getParams() {
        return this.params;
    }

    public void setParams(LinkedList<TAVariable> linkedList) {
        this.params = linkedList;
    }

    public void addParam(TAVariable tAVariable) {
        this.params.addLast(tAVariable);
    }

    public boolean hasParam(String string) {
        for (TAVariable tAVariable : this.params) {
            if (!tAVariable.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public TAVariable getReturnType() {
        return this.returnType;
    }

    public void setReturnType(TAVariable tAVariable) {
        this.returnType = tAVariable;
    }

    public void setConsumesTime(boolean bl) {
        this.consumesTime = bl;
    }

    public boolean getConsumesTime() {
        return this.consumesTime;
    }

    public void setTimingAnalyzed(boolean bl) {
        this.timingAnalyzed = bl;
    }

    public boolean getTimingAnalyzed() {
        return this.timingAnalyzed;
    }

    public void setUsesWait(boolean bl) {
        this.usesWait = bl;
        if (bl) {
            this.consumesTime = true;
        }
    }

    public boolean getUsesWait() {
        return this.usesWait;
    }

    public void setIsCalled(boolean bl) {
        this.isCalled = bl;
    }

    public boolean getIsCalled() {
        return this.isCalled;
    }

    public LinkedList<String> getFunctionCalls() {
        return this.functionCalls;
    }

    public void addFunctionCall(String string) {
        this.functionCalls.add(string);
    }

    public void setFunctionCalls(LinkedList<String> linkedList) {
        this.functionCalls = linkedList;
    }

    public Function createCopy() {
        Function function = new Function(this.name);
        function.setReturnType(this.returnType);
        function.setTemplateName(this.templateName);
        function.setFunctionCalls(this.functionCalls);
        function.setConsumesTime(this.consumesTime);
        function.setUsesWait(this.usesWait);
        function.setIsCalled(this.isCalled);
        for (int i = 0; i < this.params.size(); ++i) {
            function.addParam(this.params.get(i).createCopy(""));
        }
        return function;
    }

    public List<TAVariable> getAsTAVariables() {
        return this.getAsTAVariables("");
    }

    public List<TAVariable> getAsTAVariables(String string) {
        LinkedList<TAVariable> linkedList = new LinkedList<TAVariable>();
        linkedList.addLast(new TAChannel(string + this.name + "#" + "ctrl", false));
        for (TAVariable tAVariable : this.params) {
            linkedList.add(tAVariable.createCopy(string + this.name + "#" + "param" + "#"));
        }
        if (this.returnType != null) {
            TAVariable tAVariable = this.returnType.createCopy("");
            tAVariable.setName(string + this.name + "#" + "return");
            linkedList.addLast(tAVariable);
        }
        return linkedList;
    }

    public String toString() {
        return this.returnType + " " + this.name + "(" + this.params + ")";
    }
}

