/*
 * Decompiled with CFR 0.152.
 */
package de.tub.pes.state.model;

import de.tub.pes.state.model.TAChannel;
import de.tub.pes.state.model.TAClock;
import de.tub.pes.state.model.TAInteger;
import de.tub.pes.state.model.TALocation;
import de.tub.pes.state.model.TAModel;
import de.tub.pes.state.model.TATemplate;
import de.tub.pes.state.model.TATemplateInstance;
import de.tub.pes.state.model.TATransition;
import de.tub.pes.state.model.expression.BinaryExpression;
import de.tub.pes.state.model.expression.ConstantExpression;
import de.tub.pes.state.model.expression.Expression;
import de.tub.pes.state.model.expression.IncDecExpression;
import de.tub.pes.state.model.expression.SendReceiveExpression;

public class Constants {
    public static final String PREFIX_DELIMITER = "#";
    public static final String UPPAAL_PREFIX_DELIMITER = "\\$";
    public static final String DOT = ".";
    public static final String INTERNAL_STRING_DELIMITER = "&";
    public static final int SC_TIME_RESOLUTION = 1;
    public static final boolean USE_COMMITTED_LOCATIONS = false;
    public static final String KEYWORD_PREFIX = "";
    public static final String GLOBAL_ACTIVATE_CHAN = "activate";
    public static final String GLOBAL_DEACTIVATE_CHAN = "deactivate";
    public static final String GLOBAL_READY_PROCS_INT = "readyprocs";
    public static final String GLOBAL_UPDATE_REQUESTS_INT = "updaterequests";
    public static final String GLOBAL_DELTA_COUNT_INT = "deltacount";
    public static final String GLOBAL_UPDATE_START_CHAN = "updatestart";
    public static final String GLOBAL_UPDATE_END_CHAN = "updateend";
    public static final String GLOBAL_ADVANCE_TIME_CHAN = "advancetime";
    public static final String GLOBAL_DELTA_DELAY_CHAN = "deltadelay";
    public static final String GLOBAL_INIT_DONE_CHAN = "initdone";
    public static final String TEMPLATE_NAME_SCHEDULER = "SchedulerTemplate";
    public static final String TEMPLATE_NAME_SC_EVENT = "SCEventTemplate";
    public static final String TEMPLATE_NAME_THREAD_STARTER = "ThreadStarterTemplate";
    public static final String TEMPLATE_NAME_THREAD_STARTER_NO_INIT = "ThreadStarterNoInitTemplate";
    public static final String TEMPLATE_NAME_METHOD_STARTER = "MethodStarterTemplate";
    public static final String TEMPLATE_NAME_METHOD_STARTER_NO_INIT = "MethodStarterNoInitTemplate";
    public static final String TEMPLATE_NAME_UPDATE_STARTER = "UpdateStarterTemplate";
    public static final String TEMPLATE_NAME_INITIALIZER = "InitializerTemplate";
    public static int GLOBAL_PEQ_SIZE = 4;
    public static int DEBUG_LEVEL = 5;
    public static String GLOBAL_PEQ = "global";
    public static final String SC_PEQ_TEMPLATE_PARAM_NOTIFY = "peq_notify#ctrl";
    public static final String SC_PEQ_TEMPLATE_PARAM_NOTIFY_TRANS = "peq_notify#param#trans";
    public static final String SC_PEQ_TEMPLATE_PARAM_NOTIFY_PHASE = "peq_notify#param#phase";
    public static final String SC_PEQ_TEMPLATE_PARAM_NOTIFY_DELAY = "peq_notify#param#delay";
    public static final String SC_EVENT_TEMPLATE_PARAM_WAIT = "wait";
    public static final String SC_EVENT_TEMPLATE_PARAM_NOTIFY = "notify";
    public static final String SC_EVENT_TEMPLATE_PARAM_NOTIFY_IMM = "notify_imm";
    public static final String SC_EVENT_TEMPLATE_PARAM_NOTIFY_TIME = "notify_t";
    public static final String SC_EVENT_LOCAL_WAIT_CLOCK = "wait_clock";
    public static final String SC_EVENT_LOCAL_DELAY_INT = "ndelay";
    public static final String LOCAL_FUNCTION_CTRL_KEYWORD = "ctrl";
    public static final String LOCAL_FUNCTION_PARAM_KEYWORD = "param";
    public static final String LOCAL_FUNCTION_RETURN_KEYWORD = "return";
    public static final String LOCAL_SWITCH_EXPR_INTENTIFIER = "switch";
    public static final String LOCAL_SENSITIVE_KEYWORD = "sensitive";
    public static final String LOCAL_TIMEOUT_EVENT_KEYWORD = "timeoutevent";
    public static final String LOCAL_SENSITIVE_CHANNEL = "sensitivechan";
    public static final String REQUEST_UPDATE_CHANNEL = "requestupdate";
    public static final String UPDATE_CTRL_CHANNEL = "update#ctrl";
    public static final String DUMMY_BROADCAST_CHANNEL = "dummybchannel";
    public static final String DUMMY_CHANNEL = "dummychannel";
    public static final String DUMMY_INTEGER = "dummyinteger";
    public static final String DUMMY_CLOCK = "dummyinteger";
    public static final String INSTANCE_NAME = "this";
    public static final String QUEUEELEMENT_PREFIX = "queueelement_";
    public static final String VERSION = "1.0";

    public static void createPredefined(TAModel tAModel) {
        Constants.createInitializerTemplate(tAModel);
        Constants.createThreadStarterTemplate(tAModel, true, TEMPLATE_NAME_THREAD_STARTER);
        Constants.createThreadStarterTemplate(tAModel, false, TEMPLATE_NAME_THREAD_STARTER_NO_INIT);
        Constants.createMethodStarterTemplate(tAModel, true, TEMPLATE_NAME_METHOD_STARTER);
        Constants.createMethodStarterTemplate(tAModel, false, TEMPLATE_NAME_METHOD_STARTER_NO_INIT);
        Constants.createSCEventTemplate(tAModel);
        Constants.createUpdateHandlerTemplate(tAModel);
        tAModel.addVariable(new TAChannel(DUMMY_BROADCAST_CHANNEL, true));
        tAModel.addVariable(new TAChannel(DUMMY_CHANNEL, false));
        tAModel.addVariable(new TAInteger("dummyinteger"));
    }

    public static void createScheduler(TAModel tAModel, int n) {
        tAModel.addVariable(new TAChannel(GLOBAL_ACTIVATE_CHAN, false));
        tAModel.addVariable(new TAChannel(GLOBAL_DEACTIVATE_CHAN, false));
        tAModel.addVariable(new TAChannel(GLOBAL_UPDATE_START_CHAN, false));
        tAModel.addVariable(new TAChannel(GLOBAL_UPDATE_END_CHAN, false));
        tAModel.addVariable(new TAChannel(GLOBAL_INIT_DONE_CHAN, true));
        tAModel.addVariable(new TAChannel(GLOBAL_DELTA_DELAY_CHAN, true));
        tAModel.addVariable(new TAChannel(GLOBAL_ADVANCE_TIME_CHAN, true));
        tAModel.addVariable(new TAInteger(GLOBAL_DELTA_COUNT_INT, 0, false));
        tAModel.addVariable(new TAInteger(GLOBAL_READY_PROCS_INT, n, false));
        tAModel.addVariable(new TAInteger(GLOBAL_UPDATE_REQUESTS_INT, 0, false));
        TATemplate tATemplate = new TATemplate(TEMPLATE_NAME_SCHEDULER);
        tAModel.addTemplate(tATemplate);
        TALocation tALocation = tATemplate.createLocation("execute");
        tALocation.setUrgent(true);
        TALocation tALocation2 = tATemplate.createLocation("evaluate");
        tALocation2.setUrgent(true);
        TALocation tALocation3 = tATemplate.createLocation("update");
        tALocation3.setUrgent(true);
        TALocation tALocation4 = tATemplate.createLocation("updating");
        tALocation4.setUrgent(true);
        TALocation tALocation5 = tATemplate.createLocation("nextdelta");
        tALocation5.setUrgent(true);
        TALocation tALocation6 = tATemplate.createLocation("time_progress");
        TATransition tATransition = new TATransition(tALocation2, tALocation, new SendReceiveExpression(GLOBAL_ACTIVATE_CHAN, true));
        tATransition.setGuard(new BinaryExpression(GLOBAL_READY_PROCS_INT, "0", ">"));
        tATemplate.addTransition(tATransition);
        tATransition = new TATransition(tALocation, tALocation2, new SendReceiveExpression(GLOBAL_DEACTIVATE_CHAN, false));
        tATemplate.addTransition(tATransition);
        tATransition = new TATransition(tALocation2, tALocation3);
        tATransition.setGuard(new BinaryExpression(GLOBAL_READY_PROCS_INT, "0", "=="));
        tATransition.addUpdateExpression(new BinaryExpression(GLOBAL_DELTA_COUNT_INT, (Expression)new BinaryExpression((Expression)new BinaryExpression(GLOBAL_DELTA_COUNT_INT, "1", "+"), "2", "%"), "="));
        tATemplate.addTransition(tATransition);
        tATransition = new TATransition(tALocation3, tALocation4, new SendReceiveExpression(GLOBAL_UPDATE_START_CHAN, true));
        tATransition.setGuard(new BinaryExpression(GLOBAL_UPDATE_REQUESTS_INT, "0", ">"));
        tATemplate.addTransition(tATransition);
        tATransition = new TATransition(tALocation4, tALocation3, new SendReceiveExpression(GLOBAL_UPDATE_END_CHAN, false));
        tATemplate.addTransition(tATransition);
        tATransition = new TATransition(tALocation3, tALocation5, new SendReceiveExpression(GLOBAL_DELTA_DELAY_CHAN, true));
        tATransition.setGuard(new BinaryExpression(GLOBAL_UPDATE_REQUESTS_INT, "0", "=="));
        tATemplate.addTransition(tATransition);
        tATransition = new TATransition(tALocation5, tALocation6);
        tATransition.setGuard(new BinaryExpression(GLOBAL_READY_PROCS_INT, "0", "=="));
        tATemplate.addTransition(tATransition);
        tATransition = new TATransition(tALocation5, tALocation2);
        tATransition.setGuard(new BinaryExpression(GLOBAL_READY_PROCS_INT, "0", ">"));
        tATemplate.addTransition(tATransition);
        tATransition = new TATransition(tALocation6, tALocation2, new SendReceiveExpression(GLOBAL_ADVANCE_TIME_CHAN, false));
        tATemplate.addTransition(tATransition);
        tATemplate.setInitLocation(tALocation2);
        tAModel.addTemplateInstance(new TATemplateInstance(tATemplate, "scheduler"));
    }

    public static void createInitializerTemplate(TAModel tAModel) {
        TATemplate tATemplate = new TATemplate(TEMPLATE_NAME_INITIALIZER);
        tAModel.addTemplate(tATemplate);
        TALocation tALocation = tATemplate.createLocation();
        tALocation.setUrgent(true);
        tATemplate.setInitLocation(tALocation);
        TALocation tALocation2 = tATemplate.createLocation();
        tALocation2.setCommitted(true);
        TALocation tALocation3 = tATemplate.createLocation();
        tATemplate.addTransition(new TATransition(tALocation, tALocation2, new SendReceiveExpression(GLOBAL_DELTA_DELAY_CHAN, false)));
        tATemplate.addTransition(new TATransition(tALocation2, tALocation3, new SendReceiveExpression(GLOBAL_INIT_DONE_CHAN, true)));
        tAModel.addTemplateInstance(tATemplate.getInstance("initialization"));
    }

    public static void createThreadStarterTemplate(TAModel tAModel, boolean bl, String string) {
        Object object;
        TATemplate tATemplate = new TATemplate(string);
        tATemplate.addParameter(new TAChannel(LOCAL_FUNCTION_CTRL_KEYWORD, false));
        TALocation tALocation = tATemplate.createLocation();
        tALocation.setUrgent(true);
        TALocation tALocation2 = tATemplate.createLocation();
        tALocation2.setUrgent(true);
        TALocation tALocation3 = tATemplate.createLocation();
        TALocation tALocation4 = tATemplate.createLocation();
        tALocation4.setUrgent(true);
        TALocation tALocation5 = tATemplate.createLocation();
        if (bl) {
            tATemplate.setInitLocation(tALocation);
        } else {
            object = tATemplate.createLocation();
            ((TALocation)object).setUrgent(true);
            tATemplate.setInitLocation((TALocation)object);
            TATransition tATransition = new TATransition((TALocation)object, tALocation, new SendReceiveExpression(GLOBAL_INIT_DONE_CHAN, false));
            tATransition.addUpdateExpression(new IncDecExpression(GLOBAL_READY_PROCS_INT, true, false));
            tATemplate.addTransition(tATransition);
        }
        tATemplate.addTransition(new TATransition(tALocation, tALocation2, new SendReceiveExpression(GLOBAL_ACTIVATE_CHAN, false)));
        tATemplate.addTransition(new TATransition(tALocation2, tALocation3, new SendReceiveExpression(LOCAL_FUNCTION_CTRL_KEYWORD, true)));
        tATemplate.addTransition(new TATransition(tALocation3, tALocation4, new SendReceiveExpression(LOCAL_FUNCTION_CTRL_KEYWORD, false)));
        object = new TATransition(tALocation4, tALocation5, new SendReceiveExpression(GLOBAL_DEACTIVATE_CHAN, true));
        ((TATransition)object).addUpdateExpression(new IncDecExpression(GLOBAL_READY_PROCS_INT, false, false));
        tATemplate.addTransition((TATransition)object);
        tAModel.addTemplate(tATemplate);
    }

    public static void createMethodStarterTemplate(TAModel tAModel, boolean bl, String string) {
        TATemplate tATemplate = new TATemplate(string);
        tATemplate.addParameter(new TAChannel(LOCAL_FUNCTION_CTRL_KEYWORD, false));
        tATemplate.addParameter(new TAChannel(LOCAL_SENSITIVE_KEYWORD, true));
        TALocation tALocation = tATemplate.createLocation();
        TALocation tALocation2 = tATemplate.createLocation();
        tALocation2.setUrgent(true);
        TALocation tALocation3 = tATemplate.createLocation();
        tALocation3.setUrgent(true);
        TALocation tALocation4 = tATemplate.createLocation();
        tALocation4.setUrgent(true);
        TALocation tALocation5 = tATemplate.createLocation();
        tALocation5.setUrgent(true);
        TATransition tATransition = new TATransition(tALocation, tALocation2, new SendReceiveExpression(LOCAL_SENSITIVE_KEYWORD, false));
        tATransition.addUpdateExpression(new IncDecExpression(GLOBAL_READY_PROCS_INT, true, false));
        tATemplate.addTransition(tATransition);
        tATemplate.addTransition(new TATransition(tALocation2, tALocation3, new SendReceiveExpression(GLOBAL_ACTIVATE_CHAN, false)));
        tATemplate.addTransition(new TATransition(tALocation3, tALocation4, new SendReceiveExpression(LOCAL_FUNCTION_CTRL_KEYWORD, true)));
        tATemplate.addTransition(new TATransition(tALocation4, tALocation5, new SendReceiveExpression(LOCAL_FUNCTION_CTRL_KEYWORD, false)));
        TATransition tATransition2 = new TATransition(tALocation5, tALocation, new SendReceiveExpression(GLOBAL_DEACTIVATE_CHAN, true));
        tATransition2.addUpdateExpression(new IncDecExpression(GLOBAL_READY_PROCS_INT, false, false));
        tATemplate.addTransition(tATransition2);
        if (bl) {
            tATemplate.setInitLocation(tALocation2);
        } else {
            tATemplate.setInitLocation(tALocation);
        }
        tAModel.addTemplate(tATemplate);
    }

    public static void createSCEventTemplate(TAModel tAModel) {
        TATemplate tATemplate = new TATemplate(TEMPLATE_NAME_SC_EVENT);
        tATemplate.addParameter(new TAChannel(SC_EVENT_TEMPLATE_PARAM_WAIT, true));
        tATemplate.addParameter(new TAChannel(SC_EVENT_TEMPLATE_PARAM_NOTIFY, false));
        tATemplate.addParameter(new TAChannel(SC_EVENT_TEMPLATE_PARAM_NOTIFY_IMM, false));
        tATemplate.addParameter(new TAInteger(SC_EVENT_TEMPLATE_PARAM_NOTIFY_TIME));
        tATemplate.addLocalVar(new TAClock(SC_EVENT_LOCAL_WAIT_CLOCK));
        tATemplate.addLocalVar(new TAInteger(SC_EVENT_LOCAL_DELAY_INT));
        TALocation tALocation = tATemplate.createLocation("initL");
        TALocation tALocation2 = tATemplate.createLocation("notify_requested");
        tALocation2.setCommitted(true);
        TALocation tALocation3 = tATemplate.createLocation("wait_for_delta");
        tALocation3.setInvariant2(new BinaryExpression(SC_EVENT_LOCAL_WAIT_CLOCK, SC_EVENT_LOCAL_DELAY_INT, "<="));
        TALocation tALocation4 = tATemplate.createLocation("notify_now");
        tALocation4.setCommitted(true);
        TALocation tALocation5 = tATemplate.createLocation("advancing_time");
        tALocation5.setCommitted(true);
        tATemplate.setInitLocation(tALocation);
        TATransition tATransition = new TATransition(tALocation, tALocation2, new SendReceiveExpression(SC_EVENT_TEMPLATE_PARAM_NOTIFY, false));
        tATransition.addUpdateExpression(new BinaryExpression(SC_EVENT_LOCAL_DELAY_INT, SC_EVENT_TEMPLATE_PARAM_NOTIFY_TIME, "="));
        tATransition.addUpdateExpression(new BinaryExpression(SC_EVENT_LOCAL_WAIT_CLOCK, "0", "="));
        tATemplate.addTransition(tATransition);
        TATransition tATransition2 = new TATransition(tALocation2, tALocation3);
        tATransition2.setGuard(new BinaryExpression((Expression)new BinaryExpression(SC_EVENT_LOCAL_WAIT_CLOCK, SC_EVENT_TEMPLATE_PARAM_NOTIFY_TIME, "+"), SC_EVENT_LOCAL_DELAY_INT, "<"));
        tATransition2.addUpdateExpression(new BinaryExpression(SC_EVENT_LOCAL_DELAY_INT, SC_EVENT_TEMPLATE_PARAM_NOTIFY_TIME, "="));
        tATransition2.addUpdateExpression(new BinaryExpression(SC_EVENT_LOCAL_WAIT_CLOCK, "0", "="));
        tATemplate.addTransition(tATransition2);
        tATemplate.addTransition(new TATransition(tALocation3, tALocation2, new SendReceiveExpression(SC_EVENT_TEMPLATE_PARAM_NOTIFY, false)));
        TATransition tATransition3 = new TATransition(tALocation2, tALocation3);
        tATransition3.setGuard(new BinaryExpression((Expression)new BinaryExpression(SC_EVENT_LOCAL_WAIT_CLOCK, SC_EVENT_TEMPLATE_PARAM_NOTIFY_TIME, "+"), SC_EVENT_LOCAL_DELAY_INT, ">="));
        tATemplate.addTransition(tATransition3);
        TATransition tATransition4 = new TATransition(tALocation3, tALocation4, new SendReceiveExpression(GLOBAL_DELTA_DELAY_CHAN, false));
        tATransition4.setGuard(new ConstantExpression("ndelay == 0"));
        tATemplate.addTransition(tATransition4);
        TATransition tATransition5 = new TATransition(tALocation3, tALocation4, new SendReceiveExpression(GLOBAL_ADVANCE_TIME_CHAN, true));
        tATransition5.setGuard(new BinaryExpression((Expression)new BinaryExpression(SC_EVENT_LOCAL_WAIT_CLOCK, SC_EVENT_LOCAL_DELAY_INT, "=="), (Expression)new BinaryExpression(SC_EVENT_LOCAL_DELAY_INT, "0", "!="), "&&"));
        tATemplate.addTransition(tATransition5);
        TATransition tATransition6 = new TATransition(tALocation3, tALocation5, new SendReceiveExpression(GLOBAL_ADVANCE_TIME_CHAN, false));
        tATransition6.setGuard(new BinaryExpression(SC_EVENT_LOCAL_DELAY_INT, "0", "!="));
        tATemplate.addTransition(tATransition6);
        TATransition tATransition7 = new TATransition(tALocation5, tALocation3);
        tATransition7.setGuard(new BinaryExpression(SC_EVENT_LOCAL_WAIT_CLOCK, SC_EVENT_LOCAL_DELAY_INT, "<"));
        tATemplate.addTransition(tATransition7);
        TATransition tATransition8 = new TATransition(tALocation5, tALocation4);
        tATransition8.setGuard(new BinaryExpression(SC_EVENT_LOCAL_WAIT_CLOCK, SC_EVENT_LOCAL_DELAY_INT, "=="));
        tATemplate.addTransition(tATransition8);
        TATransition tATransition9 = new TATransition(tALocation4, tALocation);
        tATransition9.setSync(new SendReceiveExpression(SC_EVENT_TEMPLATE_PARAM_WAIT, true));
        tATransition9.addUpdateExpression(new BinaryExpression(SC_EVENT_LOCAL_WAIT_CLOCK, "0", "="));
        tATemplate.addTransition(tATransition9);
        tATemplate.addTransition(new TATransition(tALocation3, tALocation4, new SendReceiveExpression(SC_EVENT_TEMPLATE_PARAM_NOTIFY_IMM, false)));
        tATemplate.addTransition(new TATransition(tALocation, tALocation4, new SendReceiveExpression(SC_EVENT_TEMPLATE_PARAM_NOTIFY_IMM, false)));
        tAModel.addTemplate(tATemplate);
    }

    public static void createUpdateHandlerTemplate(TAModel tAModel) {
        TATemplate tATemplate = new TATemplate(TEMPLATE_NAME_UPDATE_STARTER);
        tATemplate.addParameter(new TAChannel(REQUEST_UPDATE_CHANNEL, true));
        tATemplate.addParameter(new TAChannel(UPDATE_CTRL_CHANNEL, false));
        TALocation tALocation = tATemplate.createLocation();
        TALocation tALocation2 = tATemplate.createLocation("requested");
        tALocation2.setUrgent(true);
        TALocation tALocation3 = tATemplate.createLocation("start");
        tALocation3.setUrgent(true);
        TALocation tALocation4 = tATemplate.createLocation(SC_EVENT_TEMPLATE_PARAM_WAIT);
        tALocation4.setUrgent(true);
        TALocation tALocation5 = tATemplate.createLocation("end");
        tALocation5.setUrgent(true);
        TATransition tATransition = new TATransition(tALocation, tALocation2, new SendReceiveExpression(REQUEST_UPDATE_CHANNEL, false));
        tATransition.addUpdateExpression(new IncDecExpression(GLOBAL_UPDATE_REQUESTS_INT, true, false));
        tATemplate.addTransition(tATransition);
        tATemplate.addTransition(new TATransition(tALocation2, tALocation3, new SendReceiveExpression(GLOBAL_UPDATE_START_CHAN, false)));
        tATemplate.addTransition(new TATransition(tALocation3, tALocation4, new SendReceiveExpression(UPDATE_CTRL_CHANNEL, true)));
        tATemplate.addTransition(new TATransition(tALocation4, tALocation5, new SendReceiveExpression(UPDATE_CTRL_CHANNEL, false)));
        TATransition tATransition2 = new TATransition(tALocation5, tALocation, new SendReceiveExpression(GLOBAL_UPDATE_END_CHAN, true));
        tATransition2.addUpdateExpression(new IncDecExpression(GLOBAL_UPDATE_REQUESTS_INT, false, false));
        tATemplate.addTransition(tATransition2);
        tATemplate.setInitLocation(tALocation);
        tAModel.addTemplate(tATemplate);
    }

    public static String createDelimitedString(String ... stringArray) {
        String string = KEYWORD_PREFIX;
        for (int i = 0; i < stringArray.length; ++i) {
            string = string + stringArray[i];
            if (i >= stringArray.length - 1) continue;
            string = string + PREFIX_DELIMITER;
        }
        return string;
    }
}

