/*
 * Decompiled with CFR 0.152.
 */
package de.tub.pes.state.model;

import de.tub.pes.state.model.Function;
import de.tub.pes.state.model.Module;
import de.tub.pes.state.model.ModuleInstance;
import de.tub.pes.state.model.SCModel;
import de.tub.pes.state.model.TAChannel;
import de.tub.pes.state.model.TAInteger;
import de.tub.pes.state.model.TAModel;
import de.tub.pes.state.model.TAStruct;
import de.tub.pes.state.model.TATemplate;
import de.tub.pes.state.model.TAVariable;
import de.tub.pes.state.util.ListUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class CClass {
    private LinkedList<TAVariable> members;
    private LinkedList<Function> methods;
    private static final String DIV = "#";
    private static final String INSTANCE_NAME = "this";
    private String name;
    private LinkedList<TATemplate> templates;

    public CClass(String string) {
        this.name = string;
        this.members = new LinkedList();
        this.methods = new LinkedList();
        this.templates = new LinkedList();
    }

    public boolean addMember(TAVariable tAVariable) {
        return this.members.add(tAVariable);
    }

    public LinkedList<TAVariable> getMembers() {
        return this.members;
    }

    public boolean addMethod(Function function) {
        return this.methods.add(function);
    }

    public LinkedList<Function> getMethods() {
        return this.methods;
    }

    public String getName() {
        return this.name;
    }

    public TAStruct createStruct(String string) {
        return new TAStruct("", string, this);
    }

    public void addStructMember(String string, CClass cClass) {
        this.members.add(new TAStruct("", string, cClass));
    }

    public String toString() {
        String string = this.name + "[";
        for (int i = 0; i < this.members.size(); ++i) {
            string = string + this.members.get(i).toString();
            if (i == this.members.size() - 1) continue;
            string = string + ", ";
        }
        string = string + "]";
        return string;
    }

    public String getEmptyElementInitString() {
        String string = "{";
        int n = 0;
        for (TAVariable tAVariable : this.members) {
            string = tAVariable instanceof TAStruct ? string + ((TAStruct)tAVariable).getType().getEmptyElementInitString() : string + "0";
            if (++n == this.members.size()) continue;
            string = string + ",";
        }
        string = string + "}";
        return string;
    }

    public String getEmptyElementString() {
        String string = this.name + DIV + "empty";
        return string;
    }

    public void print(OutputStreamWriter outputStreamWriter) throws IOException {
        String string = "typedef struct {" + Module.END_LINE;
        for (TAVariable tAVariable : this.members) {
            string = string + "\t" + tAVariable.createDeclarationString();
        }
        string = string + "} " + this.name + ";" + Module.END_LINE;
        string = string + this.name + " " + this.getEmptyElementString() + " = " + this.getEmptyElementInitString();
        string = string + ";" + Module.END_LINE;
        outputStreamWriter.write(string);
    }

    public Function getMethod(String string) {
        for (Function function : this.methods) {
            if (!function.getName().equals(string)) continue;
            return function;
        }
        return null;
    }

    public TATemplate getMethodTemplate(TAModel tAModel, String string) {
        String string2 = this.getName() + DIV + string;
        return tAModel.getTemplates().get(string2);
    }

    public Function createMethod(TAModel tAModel, String string) {
        Function function = new Function(string, this.getName() + DIV + string);
        this.methods.add(function);
        TATemplate tATemplate = new TATemplate(this.getName() + DIV + string);
        tATemplate.addParameter(this.createStruct(INSTANCE_NAME));
        this.templates.add(tATemplate);
        tAModel.addTemplate(tATemplate);
        return function;
    }

    public TAVariable getMember(String string) {
        if (string.startsWith("this.")) {
            string = string.substring(INSTANCE_NAME.length() + 1);
        }
        if (!string.contains(".")) {
            for (TAVariable tAVariable : this.members) {
                if (!tAVariable.getName().equals(string)) continue;
                return tAVariable;
            }
        } else {
            int n = string.indexOf(".");
            String string2 = string.substring(0, n);
            for (TAVariable tAVariable : this.members) {
                if (!tAVariable.getName().equals(string2)) continue;
                if (tAVariable instanceof TAStruct) {
                    TAStruct tAStruct = (TAStruct)tAVariable;
                    tAStruct.getType().getMember(string.substring(string2.length() + 1));
                }
                return tAVariable;
            }
        }
        return null;
    }

    public void completeDefinition(SCModel sCModel) {
        this.createTemplateHeader(sCModel.getClasses());
    }

    public void createTemplateHeader(List<CClass> list) {
        LinkedList<TAVariable> linkedList = new LinkedList<TAVariable>();
        ListUtils<TAVariable> listUtils = new ListUtils<TAVariable>();
        linkedList.add(new TAChannel("sensitive", true));
        linkedList.add(new TAChannel("timeoutevent#wait", true));
        linkedList.add(new TAChannel("timeoutevent#notify", false));
        linkedList.add(new TAChannel("timeoutevent#notify_imm", false));
        linkedList.add(new TAInteger("timeoutevent#notify_t"));
        linkedList.add(new TAStruct("", INSTANCE_NAME, this));
        listUtils.addListToList(linkedList, this.members);
        for (Function object : this.methods) {
            listUtils.addListToList(linkedList, object.getAsTAVariables());
        }
        for (TATemplate tATemplate : this.templates) {
            tATemplate.setParameters(linkedList);
        }
    }

    public List<TAVariable> getAllVisibleMembers() {
        LinkedList<TAVariable> linkedList = new LinkedList<TAVariable>();
        ListUtils<TAVariable> listUtils = new ListUtils<TAVariable>();
        listUtils.addListToList(linkedList, this.members);
        for (Function function : this.methods) {
            listUtils.addListToList(linkedList, function.getAsTAVariables());
        }
        return linkedList;
    }

    public HashMap<String, String> createParamMap(String string, String string2, LinkedList<ModuleInstance> linkedList) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (TAVariable object : this.getMembers()) {
            hashMap.put(object.getName(), string + object.getName());
            if (!(object instanceof TAStruct)) continue;
            for (TAVariable tAVariable : ((TAStruct)object).getType().getAllVisibleMembers()) {
                hashMap.put(tAVariable.getName(), string + tAVariable.getName() + DIV + object.getName());
            }
        }
        for (Function function : this.getMethods()) {
            for (TAVariable tAVariable : function.getAsTAVariables()) {
                hashMap.put(tAVariable.getName(), string + tAVariable.getName());
            }
        }
        return hashMap;
    }
}

