/*
 * Decompiled with CFR 0.152.
 */
package de.tub.pes.state.engine;

import de.tub.pes.state.engine.AbstractFunction;
import de.tub.pes.state.model.Function;
import de.tub.pes.state.model.Module;
import de.tub.pes.state.model.SCConstants;
import de.tub.pes.state.model.SCModel;
import de.tub.pes.state.model.TALocation;
import de.tub.pes.state.model.TAModel;
import de.tub.pes.state.model.TATemplate;
import de.tub.pes.state.model.TATransition;
import de.tub.pes.state.model.expression.BinaryExpression;
import de.tub.pes.state.model.expression.IncDecExpression;
import de.tub.pes.state.model.expression.SendReceiveExpression;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class WaitFunction
extends AbstractFunction {
    @Override
    public void createFunctionCall(String string, Stack<String> stack, List<String> list, Map<String, Object> map, TAModel tAModel, SCModel sCModel) {
        if (stack.size() != 0) {
            this.reportError(string, "Don't know how to evaluate this wait statement.");
            return;
        }
        Module module = (Module)map.get("CURRENT_MODULE");
        TATemplate tATemplate = (TATemplate)map.get("CURRENT_METHOD_TEMPLATE");
        TALocation tALocation = (TALocation)map.get("CURRENT_METHOD_LOCATION");
        Function function = (Function)map.get("CURRENT_METHOD");
        function.setUsesWait(true);
        TALocation tALocation2 = tATemplate.createLocation();
        TALocation tALocation3 = tATemplate.createUrgentLocation();
        TALocation tALocation4 = tATemplate.createUrgentLocation();
        TATransition tATransition = new TATransition(tALocation, tALocation2, new SendReceiveExpression("deactivate", true));
        tATransition.addUpdateExpression(new IncDecExpression("readyprocs", false, false));
        tATemplate.addTransition(tATransition);
        TATransition tATransition2 = new TATransition(tALocation3, tALocation4, new SendReceiveExpression("activate", false));
        tATemplate.addTransition(tATransition2);
        map.put("CURRENT_METHOD_LOCATION", tALocation4);
        String string2 = null;
        boolean bl = false;
        switch (list.size()) {
            case 0: {
                this.addStaticSensWait(tATemplate, tALocation2, tALocation3);
                break;
            }
            case 1: {
                String string3 = list.get(0);
                if (module.getMember(string3) != null || tATemplate.containsLocalVar(string3)) {
                    TALocation tALocation5 = tATemplate.createLocation();
                    tALocation2.setCommitted(true);
                    this.addTimedWait(tATemplate, tALocation2, tALocation5, tALocation3, string3);
                    break;
                }
                string2 = list.get(0);
                break;
            }
            case 3: {
                string2 = list.get(2);
            }
            case 2: {
                String string4 = list.get(0);
                String string5 = list.get(1);
                tALocation2.setCommitted(true);
                TALocation tALocation6 = tATemplate.createLocation();
                if (module.getMember(string4) != null || tATemplate.containsLocalVar(string4)) {
                    int n = SCConstants.getTimeFactor(string5);
                    String string6 = n == 1 ? string4 : string4 + "*" + n;
                    this.addTimedWait(tATemplate, tALocation2, tALocation6, tALocation3, string6);
                } else {
                    try {
                        int n = SCConstants.getTimeUnits(string4, string5);
                        this.addTimedWait(tATemplate, tALocation2, tALocation6, tALocation3, new Integer(n).toString());
                    }
                    catch (Exception exception) {
                        this.reportError(string, "Illegal argument in wait statement.");
                    }
                }
                tALocation2 = tALocation6;
                bl = true;
            }
        }
        if (string2 != null) {
            if (string2.indexOf(124) > 0) {
                this.addEventOrListWait(tATemplate, tALocation2, tALocation3, string2, bl);
            } else if (string2.indexOf(38) > 0) {
                this.addEventAndListWait(tATemplate, tALocation2, tALocation3, string2, bl);
            } else if (module.isEvent(string2, sCModel)) {
                this.addEventWait(tATemplate, tALocation2, tALocation3, string2, bl);
            } else {
                this.reportError(string, "Illegal argument in wait statement.");
            }
        }
    }

    private void addStaticSensWait(TATemplate tATemplate, TALocation tALocation, TALocation tALocation2) {
        TATransition tATransition = new TATransition(tALocation, tALocation2, new SendReceiveExpression("sensitive", false));
        tATransition.addUpdateExpression(new IncDecExpression("readyprocs", true, false));
        tATemplate.addTransition(tATransition);
    }

    private void addEventWait(TATemplate tATemplate, TALocation tALocation, TALocation tALocation2, String string, boolean bl) {
        String string2 = string + "#" + "wait";
        if (bl) {
            TALocation tALocation3 = tATemplate.createLocation();
            tALocation3.setCommitted(true);
            tATemplate.addTransition(new TATransition(tALocation, tALocation3, new SendReceiveExpression(string2, false)));
            TATransition tATransition = new TATransition(tALocation3, tALocation2, new SendReceiveExpression("timeoutevent#notify_imm", true));
            tATransition.addUpdateExpression(new IncDecExpression("readyprocs", true, false));
            tATemplate.addTransition(tATransition);
        } else {
            TATransition tATransition = new TATransition(tALocation, tALocation2, new SendReceiveExpression(string2, false));
            tATransition.addUpdateExpression(new IncDecExpression("readyprocs", true, false));
            tATemplate.addTransition(tATransition);
        }
    }

    private void addEventOrListWait(TATemplate tATemplate, TALocation tALocation, TALocation tALocation2, String string, boolean bl) {
        String string2 = string.replaceAll("[ \\(\\)]+", "");
        String string3 = "#wait";
        String[] stringArray = string2.split("\\|");
        if (bl) {
            TALocation tALocation3 = tATemplate.createLocation();
            tALocation3.setCommitted(true);
            for (String string4 : stringArray) {
                tATemplate.addTransition(new TATransition(tALocation, tALocation3, new SendReceiveExpression(string4 + string3, false)));
            }
            TATransition tATransition = new TATransition(tALocation3, tALocation2, new SendReceiveExpression("timeoutevent#notify_imm", true));
            tATransition.addUpdateExpression(new IncDecExpression("readyprocs", true, false));
            tATemplate.addTransition(tATransition);
        } else {
            for (String string5 : stringArray) {
                TATransition tATransition = new TATransition(tALocation, tALocation2, new SendReceiveExpression(string5 + string3, false));
                tATransition.addUpdateExpression(new IncDecExpression("readyprocs", true, false));
                tATemplate.addTransition(tATransition);
            }
        }
    }

    private void addEventAndListWait(TATemplate tATemplate, TALocation tALocation, TALocation tALocation2, String string, boolean bl) {
    }

    private void addTimedWait(TATemplate tATemplate, TALocation tALocation, TALocation tALocation2, TALocation tALocation3, String string) {
        String string2 = "timeoutevent#";
        TATransition tATransition = new TATransition(tALocation, tALocation2, new SendReceiveExpression(string2 + "notify", true));
        tATransition.addUpdateExpression(new BinaryExpression(string2 + "notify_t", string, "="));
        TATransition tATransition2 = new TATransition(tALocation2, tALocation3, new SendReceiveExpression(string2 + "wait", false));
        tATransition2.addUpdateExpression(new IncDecExpression("readyprocs", true, false));
        tATemplate.addTransition(tATransition);
        tATemplate.addTransition(tATransition2);
    }
}

