/*
 * Decompiled with CFR 0.152.
 */
package de.tub.pes.state.engine;

import de.tub.pes.state.engine.AbstractTransformer;
import de.tub.pes.state.model.SCModel;
import de.tub.pes.state.model.TAModel;
import java.util.Map;
import java.util.Stack;
import org.w3c.dom.Node;

public class UnaryExpressionTransformer
extends AbstractTransformer {
    @Override
    public void transformNode(Node node, Map<String, Object> map, TAModel tAModel, SCModel sCModel) {
        this.handleChildNodes(node, map, tAModel, sCModel);
        Stack stack = (Stack)map.get("OPERAND_STACK");
        String string = null;
        Node node2 = this.findChildNode(node, "unary_operator");
        String string2 = this.getAttributeValue(node2, "operator");
        string = (String)stack.pop();
        if (string2.equals("pointer") || string2.equals("ref")) {
            this.reportError(node, "Pointer and refence operator are not allowed yet.");
            stack.push(string);
        } else {
            if (string2.equals("add")) {
                string = "+(" + string + ")";
            } else if (string2.equals("minnus")) {
                string = "-(" + string + ")";
            } else if (string2.equals("tilde")) {
                string = "~(" + string + ")";
                this.reportError(node, "UPPAAL cannot handle bitwise negation.");
            } else if (string2.equals("not")) {
                string = "!(" + string + ")";
            }
            stack.push(string);
        }
    }
}

