/*
 * Decompiled with CFR 0.152.
 */
package de.tub.pes.state.engine;

import de.tub.pes.state.engine.KnownFunctionTransformer;
import de.tub.pes.state.engine.KnownTypeTransformer;
import de.tub.pes.state.engine.NoEffectTransformer;
import de.tub.pes.state.engine.Transformer;
import de.tub.pes.state.util.IOUtil;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Node;

public class TransformerFactory {
    public static final String CONFIG_FOLDER = "config/";
    public static final String TRANSFORMERS_DEFINITION_FILE = "transformers.properties";
    public static final String FUNCTIONS_DEFINITION_FILE = "functions.properties";
    public static final String TYPES_DEFINITION_FILE = "types.properties";
    public static final String SIMPLE_TYPES_DEFINITION_FILE = "simpletypes.properties";
    private static Map<String, Transformer> transformers;
    private static Map<String, KnownFunctionTransformer> functions;
    private static Map<String, KnownTypeTransformer> types;
    private static List<String> simpletypes;
    private static Properties transcfg;
    private static Properties funccfg;
    private static Properties typecfg;

    public static void initialize() throws FileNotFoundException, IOException {
        TransformerFactory.initialize("config/transformers.properties", "config/functions.properties", "config/types.properties", "config/simpletypes.properties");
    }

    public static void initialize(String string, String string2, String string3, String string4) throws FileNotFoundException, IOException {
        transformers = new HashMap<String, Transformer>();
        transcfg = new Properties();
        transcfg.load(IOUtil.getInputStream(string));
        functions = new HashMap<String, KnownFunctionTransformer>();
        funccfg = new Properties();
        funccfg.load(IOUtil.getInputStream(string2));
        types = new HashMap<String, KnownTypeTransformer>();
        typecfg = new Properties();
        typecfg.load(IOUtil.getInputStream(string3));
        simpletypes = new LinkedList<String>();
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(IOUtil.getInputStream(string4)));
            while (bufferedReader.ready()) {
                String string5 = bufferedReader.readLine();
                string5 = string5.replaceAll("^[ \\s\\t]*", "");
                if ((string5 = string5.replaceAll("[ \\s\\t]*$", "")) == "" || string5.startsWith("#")) continue;
                simpletypes.add(string5);
            }
        }
        catch (Exception exception) {
            System.out.println("Problem reading simple type configuration. " + exception.getMessage());
        }
    }

    public static boolean isSimpleType(String string) {
        return simpletypes.contains(string);
    }

    public static Transformer getTransformer(String string) {
        if (transformers == null || transcfg == null) {
            System.out.println("ERROR: TransformerFactory not initialized!");
            return null;
        }
        Transformer transformer = transformers.get(string);
        if (transformer == null) {
            transformer = TransformerFactory.createTransformer(string);
        }
        return transformer;
    }

    public static Transformer getTransformer(Node node) {
        return TransformerFactory.getTransformer(node.getNodeName());
    }

    private static Transformer createTransformer(String string) {
        String string2 = transcfg.getProperty(string);
        if (string2 == null || string2 == "") {
            return new NoEffectTransformer();
        }
        try {
            URL[] uRLArray = new URL[]{TransformerFactory.class.getResource("")};
            URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
            Transformer transformer = (Transformer)uRLClassLoader.loadClass(string2).newInstance();
            transformers.put(string, transformer);
            return transformer;
        }
        catch (InstantiationException instantiationException) {
            System.out.println("ERROR: Transformer for node type '" + string + "' can not be instantiated. The classname associated to this node is '" + string2 + "'.");
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            System.out.println("ERROR: Transformer for node type '" + string + "' can not be created. The class file associated to this node, '" + string2 + "', is not accessible.");
            illegalAccessException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("ERROR: Transformer for node type '" + string + "' can not be created. The class file associated to this node, '" + string2 + "', can not be found.");
            classNotFoundException.printStackTrace();
        }
        return new NoEffectTransformer();
    }

    public static KnownFunctionTransformer getFunctionTransformer(String string) {
        if (functions == null || funccfg == null) {
            System.out.println("ERROR: TransformerFactory not initialized!");
            return null;
        }
        KnownFunctionTransformer knownFunctionTransformer = functions.get(string);
        if (knownFunctionTransformer == null) {
            knownFunctionTransformer = TransformerFactory.createFunctionTransformer(string);
        }
        return knownFunctionTransformer;
    }

    private static KnownFunctionTransformer createFunctionTransformer(String string) {
        String string2 = funccfg.getProperty(string);
        if (string2 == null || string2 == "") {
            return null;
        }
        try {
            URL[] uRLArray = new URL[]{TransformerFactory.class.getResource("")};
            URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
            KnownFunctionTransformer knownFunctionTransformer = (KnownFunctionTransformer)uRLClassLoader.loadClass(string2).newInstance();
            functions.put(string, knownFunctionTransformer);
            return knownFunctionTransformer;
        }
        catch (InstantiationException instantiationException) {
            System.out.println("ERROR: Transformer for node type '" + string + "' can not be instantiated. The classname associated to this node is '" + string2 + "'.");
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            System.out.println("ERROR: Transformer for node type '" + string + "' can not be created. The class file associated to this node, '" + string2 + "', is not accessible.");
            illegalAccessException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("ERROR: Transformer for node type '" + string + "' can not be created. The class file associated to this node, '" + string2 + "', can not be found.");
            classNotFoundException.printStackTrace();
        }
        return null;
    }

    public static KnownTypeTransformer getTypeTransformer(String string) {
        if (types == null || typecfg == null) {
            System.out.println("ERROR: TransformerFactory not initialized!");
            return null;
        }
        KnownTypeTransformer knownTypeTransformer = types.get(string);
        if (knownTypeTransformer == null) {
            knownTypeTransformer = TransformerFactory.createTypeTransformer(string);
        }
        return knownTypeTransformer;
    }

    private static KnownTypeTransformer createTypeTransformer(String string) {
        String string2 = typecfg.getProperty(string);
        if (string2 == null || string2 == "") {
            return null;
        }
        try {
            URL[] uRLArray = new URL[]{TransformerFactory.class.getResource("")};
            URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
            KnownTypeTransformer knownTypeTransformer = (KnownTypeTransformer)uRLClassLoader.loadClass(string2).newInstance();
            types.put(string, knownTypeTransformer);
            String string3 = typecfg.getProperty(string + ".impl");
            if (string3 != null && string3 != "") {
                knownTypeTransformer.setImplementation(CONFIG_FOLDER + string3);
            }
            return knownTypeTransformer;
        }
        catch (InstantiationException instantiationException) {
            System.out.println("ERROR: Transformer for node type '" + string + "' can not be instantiated. The classname associated to this node is '" + string2 + "'.");
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            System.out.println("ERROR: Transformer for node type '" + string + "' can not be created. The class file associated to this node, '" + string2 + "', is not accessible.");
            illegalAccessException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("ERROR: Transformer for node type '" + string + "' can not be created. The class file associated to this node, '" + string2 + "', can not be found.");
            classNotFoundException.printStackTrace();
        }
        return null;
    }
}

