/*
 * Decompiled with CFR 0.152.
 */
package de.tub.pes.state.engine;

import de.tub.pes.state.engine.AbstractTransformer;
import de.tub.pes.state.model.Constructor;
import de.tub.pes.state.model.Function;
import de.tub.pes.state.model.Module;
import de.tub.pes.state.model.ModuleInstance;
import de.tub.pes.state.model.Peq;
import de.tub.pes.state.model.SCModel;
import de.tub.pes.state.model.TAInteger;
import de.tub.pes.state.model.TAModel;
import de.tub.pes.state.model.TAVariable;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import org.w3c.dom.Node;

public class SuperClassInitTransformer
extends AbstractTransformer {
    @Override
    public void transformNode(Node node, Map<String, Object> map, TAModel tAModel, SCModel sCModel) {
        Node node2 = this.findChildNode(node, "qualified_id");
        if (node2 == null) {
            return;
        }
        String string = this.getAttributeValue(node2, "name");
        map.put("OPERAND_STACK", new Stack());
        this.handleNode(this.findChildNode(node, "arguments_list"), map, tAModel, sCModel);
        Stack stack = (Stack)map.get("OPERAND_STACK");
        LinkedList<String> linkedList = new LinkedList<String>();
        while (stack.size() > 0) {
            linkedList.addFirst((String)stack.pop());
        }
        Module module = (Module)map.get("CURRENT_MODULE");
        TAVariable tAVariable = module.getMember(string);
        if (tAVariable != null) {
            block20: {
                if (linkedList.size() == 1) {
                    if (tAVariable instanceof TAInteger) {
                        String string2 = (String)linkedList.get(0);
                        if (string2.equals("true")) {
                            ((TAInteger)tAVariable).setInitValue(1);
                        } else if (string2.equals("false")) {
                            ((TAInteger)tAVariable).setInitValue(0);
                        } else {
                            Constructor constructor = module.getConstructor();
                            if (constructor.hasParam(string2)) {
                                constructor.addIniter(string2, tAVariable);
                            } else {
                                try {
                                    if (string2.contains("[^-+\\*/[0-9]\\(\\)")) {
                                        this.reportError(node, "Illegal assignment in constructor. Only constant member initializations allowed.");
                                        break block20;
                                    }
                                    ((TAInteger)tAVariable).setInitValue(string2);
                                }
                                catch (Exception exception) {
                                    this.reportError(node, "Cannot handle initializer format of " + string + ".");
                                }
                            }
                        }
                    } else {
                        this.reportError(node, "Initialization of type of simple member " + string + " not implemented.");
                    }
                } else {
                    this.reportError(node, "Wrong number of arguments to initialize simple member " + string + ".");
                }
            }
            return;
        }
        if (module.getPeq(string) != null) {
            if (linkedList.size() == 3) {
                Peq peq = module.getPeq(string);
                Function function = null;
                String string3 = linkedList.get(2);
                for (Function function2 : module.getMethods()) {
                    if (!function2.getName().equals(string3)) continue;
                    function = function2;
                    break;
                }
                peq.setCallbackFunction(function);
            }
            return;
        }
        ModuleInstance moduleInstance = module.getComplexMember(string);
        if (moduleInstance != null) {
            moduleInstance.setArguments(linkedList);
            return;
        }
        this.reportError(node, "Ignoring superclass initializer for " + string + ".");
    }
}

