/*
 * Decompiled with CFR 0.152.
 */
package de.tub.pes.state.engine;

import de.tub.pes.state.engine.AbstractTransformer;
import de.tub.pes.state.engine.KnownTypeTransformer;
import de.tub.pes.state.engine.TransformerFactory;
import de.tub.pes.state.model.CClass;
import de.tub.pes.state.model.Function;
import de.tub.pes.state.model.Module;
import de.tub.pes.state.model.SCModel;
import de.tub.pes.state.model.TAModel;
import de.tub.pes.state.model.TAStruct;
import de.tub.pes.state.model.TAVariable;
import java.util.LinkedList;
import java.util.Map;
import org.w3c.dom.Node;

public class SCPortSpecifierTransformer
extends AbstractTransformer {
    @Override
    public void transformNode(Node node, Map<String, Object> map, TAModel tAModel, SCModel sCModel) {
        String string;
        String string2 = this.getAttributeValue(node, "name");
        if (string2.equals("sc_port")) {
            map.put("IS_PORT_DECLARATION", new Boolean(true));
            this.handleChildNodes(node, map, tAModel, sCModel);
            return;
        }
        if (string2.equals("sc_in") || string2.equals("sc_out") || string2.equals("sc_inout")) {
            map.put("IS_PORT_DECLARATION", new Boolean(true));
            string2 = "sc_signal";
        } else if (string2.equals("sc_fifo_in") || string2.equals("sc_fifo_out")) {
            map.put("IS_PORT_DECLARATION", new Boolean(true));
            string2 = "sc_fifo";
        } else if (string2.equals("tlm_initiator_socket") || string2.equals("tlm_target_socket")) {
            map.put("IS_SOCKET_DECLARATION", new Boolean(true));
            string2 = "tlm_fw_bw_if";
        } else {
            this.reportError(node, string2 + ":Unknown port type.");
            return;
        }
        KnownTypeTransformer knownTypeTransformer = TransformerFactory.getTypeTransformer(string2);
        if (knownTypeTransformer != null) {
            knownTypeTransformer.createType(sCModel, tAModel);
        } else {
            this.reportError(node, "Configuration error: Can not find implementation for type " + string2 + ".");
        }
        Node node2 = this.findChildNode(node, "declaration_specifiers");
        LinkedList<String> linkedList = new LinkedList<String>();
        if (node2 != null) {
            this.handleNode(node2, map, tAModel, sCModel);
            string = (String)map.get("LAST_DECLARED_TYPE");
            linkedList.add(string);
            map.put("LAST_DECLARED_TEMPLATE_ARGS", linkedList);
        } else {
            map.put("LAST_DECLARED_TEMPLATE_ARGS", null);
        }
        if (string2.equals("tlm_fw_bw_if")) {
            string = "";
            if (linkedList.isEmpty()) {
                System.out.println("WARNING: No type given for tlm_fw_bw_if.");
            } else {
                string = (String)linkedList.get(0);
            }
            CClass cClass = sCModel.getClass(string);
            if (cClass == null) {
                System.out.println("WARNING: Type " + string + " of tlm_fw_bw_if is unknown.");
            } else if (sCModel.getModule("tlm_fw_bw_if#" + string) == null) {
                Module module = sCModel.getModule("tlm_fw_bw_if").createCopy("#" + string, tAModel, sCModel);
                for (Function function : module.getMethods()) {
                    for (TAVariable tAVariable : function.getParams()) {
                        if (!(tAVariable instanceof TAStruct) || !((TAStruct)tAVariable).getType().getName().equals("data")) continue;
                        ((TAStruct)tAVariable).setType(cClass);
                    }
                }
                sCModel.addModule("tlm_fw_bw_if#" + string, module);
            }
        }
        map.put("LAST_DECLARED_TYPE", string2);
    }
}

