/*
 * Decompiled with CFR 0.152.
 */
package de.tub.pes.state.engine;

import de.tub.pes.state.engine.AbstractTransformer;
import de.tub.pes.state.model.Function;
import de.tub.pes.state.model.Module;
import de.tub.pes.state.model.SCConstants;
import de.tub.pes.state.model.SCModel;
import de.tub.pes.state.model.TALocation;
import de.tub.pes.state.model.TAModel;
import de.tub.pes.state.model.TATemplate;
import de.tub.pes.state.model.TATransition;
import de.tub.pes.state.model.expression.BinaryExpression;
import de.tub.pes.state.model.expression.SendReceiveExpression;
import java.util.Map;
import java.util.Stack;
import org.w3c.dom.Node;

public class SCNotifyTransformer
extends AbstractTransformer {
    @Override
    public void transformNode(Node node, Map<String, Object> map, TAModel tAModel, SCModel sCModel) {
        TALocation tALocation;
        Stack stack = (Stack)map.get("OPERAND_STACK");
        TATemplate tATemplate = (TATemplate)map.get("CURRENT_METHOD_TEMPLATE");
        TALocation tALocation2 = (TALocation)map.get("CURRENT_METHOD_LOCATION");
        String string = this.getAttributeValue(node, "name").replaceAll("\\.", "#");
        Function function = (Function)map.get("CURRENT_METHOD");
        int n = stack.size();
        this.handleChildNodes(node, map, tAModel, sCModel);
        int n2 = stack.size();
        if (tATemplate.getName().startsWith("sc_clock")) {
            tALocation2.setUrgent(false);
            tALocation2.setCommitted(true);
        }
        if (n == n2) {
            tALocation = tATemplate.createUrgentLocation();
            tATemplate.addTransition(new TATransition(tALocation2, tALocation, new SendReceiveExpression(string + "#" + "notify_imm", true)));
        } else if (n + 2 == n2) {
            String string2 = (String)stack.pop();
            String string3 = (String)stack.pop();
            int n3 = SCConstants.getTimeUnits(string3, string2);
            tALocation = this.createSimpleSyncTransition(string + "#", Integer.toString(n3), tATemplate, tALocation2);
        } else if (n + 1 == n2) {
            String string4 = (String)stack.pop();
            tALocation = string4.equals("SC_ZERO_TIME") ? this.createSimpleSyncTransition(string + "#", "0", tATemplate, tALocation2) : this.createSimpleSyncTransition(string + "#", string4, tATemplate, tALocation2);
        } else {
            Module module = (Module)map.get("CURRENT_MODULE");
            if (n + 3 == n2 && module.isPeq(string, sCModel)) {
                String string5 = (String)stack.pop();
                String string6 = (String)stack.pop();
                String string7 = (String)stack.pop();
                tALocation = tATemplate.createUrgentLocation();
                TATransition tATransition = new TATransition(tALocation2, tALocation, new SendReceiveExpression(string + "#" + "peq_notify#ctrl", true));
                tATransition.addUpdateExpression(new BinaryExpression(string + "#" + "peq_notify#param#delay", string5, "="));
                tATransition.addUpdateExpression(new BinaryExpression(string + "#" + "peq_notify#param#phase", string6, "="));
                tATransition.addUpdateExpression(new BinaryExpression(string + "#" + "peq_notify#param#trans", string7, "="));
                tATemplate.addTransition(tATransition);
                if (function != null && function.getTemplateName() != null) {
                    function.addFunctionCall(string + "#" + "notify");
                }
            } else {
                this.reportError(node, "event notification with notify() with more than two parameters not supported.");
                tALocation = tALocation2;
            }
        }
        map.put("CURRENT_METHOD_LOCATION", tALocation);
    }

    private TALocation createSimpleSyncTransition(String string, String string2, TATemplate tATemplate, TALocation tALocation) {
        TALocation tALocation2 = tATemplate.createUrgentLocation();
        TATransition tATransition = new TATransition(tALocation, tALocation2, new SendReceiveExpression(string + "notify", true));
        tATransition.addUpdateExpression(new BinaryExpression(string + "notify_t", string2, "="));
        tATemplate.addTransition(tATransition);
        return tALocation2;
    }
}

