/*
 * Decompiled with CFR 0.152.
 */
package de.tub.pes.state.engine;

import de.tub.pes.state.engine.AbstractTransformer;
import de.tub.pes.state.model.SCModel;
import de.tub.pes.state.model.TALocation;
import de.tub.pes.state.model.TAModel;
import de.tub.pes.state.model.TATemplate;
import de.tub.pes.state.model.TATransition;
import de.tub.pes.state.model.expression.ConstantExpression;
import java.util.Map;
import java.util.Stack;
import org.w3c.dom.Node;

public class PrePostModifierTransformer
extends AbstractTransformer {
    public static final String PRE_DEC = "predecrement_node";
    public static final String PRE_INC = "preincrement_node";
    public static final String POST_INC = "postincrement_node";
    public static final String POST_DEC = "postdecrement_node";

    @Override
    public void transformNode(Node node, Map<String, Object> map, TAModel tAModel, SCModel sCModel) {
        this.handleChildNodes(node, map, tAModel, sCModel);
        Stack stack = (Stack)map.get("OPERAND_STACK");
        String string = node.getNodeName();
        String string2 = (String)stack.pop();
        if (!string2.matches("^[a-zA-Z0-9_]+$")) {
            string2 = "(" + string2 + ")";
        }
        if (string.equals(PRE_DEC)) {
            stack.push("--" + string2 + "");
        } else if (string.equals(PRE_INC)) {
            stack.push("++" + string2 + "");
        } else if (string.equals(POST_DEC)) {
            stack.push("" + string2 + "--");
        } else if (string.equals(POST_INC)) {
            stack.push("" + string2 + "++");
        } else {
            this.reportError(node, "Configuration Error: PrePostModifierTransformer should only be used for post/pre in/decrement nodes.");
        }
        Node node2 = node.getParentNode();
        if (node2.getNodeName().equals("block_statement")) {
            String string3 = (String)stack.pop();
            TATemplate tATemplate = (TATemplate)map.get("CURRENT_METHOD_TEMPLATE");
            TALocation tALocation = (TALocation)map.get("CURRENT_METHOD_LOCATION");
            TALocation tALocation2 = tATemplate.createStandardLocation();
            TATransition tATransition = new TATransition(tALocation, tALocation2);
            tATemplate.addTransition(tATransition);
            tATransition.addUpdateExpression(new ConstantExpression(string3));
            map.put("CURRENT_METHOD_LOCATION", tALocation2);
        }
    }
}

