/*
 * Decompiled with CFR 0.152.
 */
package de.tub.pes.state.engine;

import de.tub.pes.state.engine.AbstractTransformer;
import de.tub.pes.state.engine.KnownTypeTransformer;
import de.tub.pes.state.engine.TransformerFactory;
import de.tub.pes.state.model.CClass;
import de.tub.pes.state.model.Module;
import de.tub.pes.state.model.Peq;
import de.tub.pes.state.model.SCModel;
import de.tub.pes.state.model.TAArray;
import de.tub.pes.state.model.TAChannel;
import de.tub.pes.state.model.TAInteger;
import de.tub.pes.state.model.TAModel;
import de.tub.pes.state.model.TAVariable;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import org.w3c.dom.Node;

public class MemberDeclaratorTransformer
extends AbstractTransformer {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void transformNode(Node node, Map<String, Object> map, TAModel tAModel, SCModel sCModel) {
        Node node2 = this.findChildNode(node, "declarator");
        Node node3 = this.findChildNode(node2, "qualified_id");
        Node node4 = this.findChildNode(node2, "declarator_suffixes");
        String string = this.getAttributeValue(node3, "name");
        String string2 = (String)map.get("LAST_DECLARED_TYPE");
        if (string2 == null) {
            return;
        }
        CClass cClass = (CClass)map.get("CURRENT_CLASS");
        if (cClass != null) {
            if (string2.equals("int")) {
                TAVariable tAVariable = this.getIntVariable(node, map, tAModel, sCModel, node4, string, string2);
                this.addVar(tAVariable, cClass);
                return;
            } else {
                CClass cClass2 = sCModel.getClass(string2);
                if (cClass2 == null) throw new UnsupportedOperationException("Either you are trying to use a struct inside a struct which has not been declared previously or you are trying to put an SC_MODULE inside a struct, which is both not (yet) supported.");
                if (cClass2.getName().equals(cClass.getName())) {
                    this.reportError(node, "Recursive data structures not supported! Ignoring " + string2 + " " + string);
                    return;
                } else {
                    cClass.addStructMember(string, cClass2);
                }
            }
            return;
        } else {
            Module module = (Module)map.get("CURRENT_MODULE");
            if (((Boolean)map.get("IS_PORT_DECLARATION")).booleanValue()) {
                module.addPort(string, string2);
                return;
            } else if (((Boolean)map.get("IS_SOCKET_DECLARATION")).booleanValue()) {
                LinkedList linkedList = (LinkedList)map.get("LAST_DECLARED_TEMPLATE_ARGS");
                String string3 = (String)linkedList.get(0);
                module.addSocket(string, string2 + "#" + string3);
                return;
            } else if (string2.equals("int")) {
                TAVariable tAVariable = this.getIntVariable(node, map, tAModel, sCModel, node4, string, string2);
                this.addVar(tAVariable, module);
                return;
            } else if (sCModel.getSimpleType(string2) != null) {
                TAInteger tAInteger = new TAInteger(string);
                this.addVar((TAVariable)tAInteger, module);
                return;
            } else if (string2.equals("sc_event")) {
                this.createEvent(string, module);
                return;
            } else if (string2.equals("peq_with_cb_and_phase")) {
                LinkedList linkedList = (LinkedList)map.get("LAST_DECLARED_TEMPLATE_ARGS");
                String string4 = (String)linkedList.getLast();
                if (linkedList.size() == 2 && sCModel.isKnownType(string4)) {
                    Peq peq = sCModel.getPeq(string4).createInstance(string, sCModel, tAModel);
                    module.addPeq(string, peq, tAModel);
                    return;
                } else {
                    this.reportError(node, "Found either an incorrect argument count or the datatype used in the peq was not declared.");
                }
                return;
            } else {
                KnownTypeTransformer knownTypeTransformer = TransformerFactory.getTypeTransformer(string2);
                if (knownTypeTransformer != null) {
                    LinkedList linkedList = (LinkedList)map.get("LAST_DECLARED_TEMPLATE_ARGS");
                    knownTypeTransformer.createMember(string, null, linkedList, map, tAModel, sCModel);
                    return;
                } else {
                    CClass cClass3 = sCModel.getClass(string2);
                    if (cClass3 != null) {
                        module.addSimpleMember(cClass3.createStruct(string));
                        return;
                    } else {
                        Module module2 = sCModel.getModule(string2);
                        module.addComplexMember(string, module2);
                    }
                }
            }
        }
    }

    private TAVariable getIntVariable(Node node, Map<String, Object> map, TAModel tAModel, SCModel sCModel, Node node2, String string, String string2) {
        int n = Integer.parseInt((String)map.get("LAST_DECLARED_TYPE_LENGTH"));
        if (node2 == null) {
            TAInteger tAInteger = new TAInteger(string);
            if (n != 0) {
                tAInteger.setBits(n);
            }
            return tAInteger;
        }
        if (n != 0) {
            int n2 = -(1 << n - 1);
            int n3 = -n2 - 1;
            string2 = string2 + "[" + n2 + ", " + n3 + "]";
        }
        String string3 = this.getAttributeValue(node2, "arrayCounter");
        TAArray tAArray = new TAArray(string, string2, string3, true, false);
        Stack stack = new Stack();
        map.put("OPERAND_STACK", stack);
        this.handleNode(node2, map, tAModel, sCModel);
        for (int i = Integer.parseInt(string3) - 1; i >= 0; --i) {
            try {
                tAArray.addSizeOfDimension(Integer.parseInt((String)stack.pop()), i);
                continue;
            }
            catch (Exception exception) {
                this.reportError(node, "Error in array declaration: Dimensions expressions are required and can only be constant expressions.");
            }
        }
        return tAArray;
    }

    private void createEvent(String string, Module module) {
        String string2 = string + "#";
        module.addEvent(string);
        this.addVar((TAVariable)new TAChannel(string2 + "wait", true), module);
        this.addVar((TAVariable)new TAChannel(string2 + "notify", false), module);
        this.addVar((TAVariable)new TAChannel(string2 + "notify_imm", false), module);
        this.addVar((TAVariable)new TAInteger(string2 + "notify_t"), module);
    }

    private void addVar(TAVariable tAVariable, Module module) {
        module.addSimpleMember(tAVariable);
    }

    private void addVar(TAVariable tAVariable, CClass cClass) {
        cClass.addMember(tAVariable);
    }
}

