/*
 * Decompiled with CFR 0.152.
 */
package de.tub.pes.state.engine;

import de.tub.pes.state.engine.AbstractTransformer;
import de.tub.pes.state.engine.KnownTypeTransformer;
import de.tub.pes.state.engine.TransformerFactory;
import de.tub.pes.state.model.CClass;
import de.tub.pes.state.model.Module;
import de.tub.pes.state.model.ModuleInstance;
import de.tub.pes.state.model.SCModel;
import de.tub.pes.state.model.TAArray;
import de.tub.pes.state.model.TAInteger;
import de.tub.pes.state.model.TALocation;
import de.tub.pes.state.model.TAModel;
import de.tub.pes.state.model.TAStruct;
import de.tub.pes.state.model.TATemplate;
import de.tub.pes.state.model.TATransition;
import de.tub.pes.state.model.TAVariable;
import de.tub.pes.state.model.expression.BinaryExpression;
import de.tub.pes.state.model.expression.Expression;
import de.tub.pes.state.model.expression.VariableExpression;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import org.w3c.dom.Node;

public class InitDeclaratorTransformer
extends AbstractTransformer {
    @Override
    public void transformNode(Node node, Map<String, Object> map, TAModel tAModel, SCModel sCModel) {
        Node node2 = this.findChildNode(node, "declarator");
        Node node3 = this.findChildNode(node2, "qualified_id");
        String string = this.getAttributeValue(node3, "name");
        String string2 = (String)map.get("LAST_DECLARED_TYPE");
        if (map.containsKey("CURRENT_LOCATION") && map.get("CURRENT_LOCATION").equals((Object)AbstractTransformer.LocationType.MAIN)) {
            this.handleNode(this.findChildNode(node, "arguments_list"), map, tAModel, sCModel);
            Stack stack = (Stack)map.get("OPERAND_STACK");
            LinkedList<String> linkedList = new LinkedList<String>();
            while (stack.size() > 0) {
                linkedList.addFirst((String)stack.pop());
            }
            if (string2 != null) {
                KnownTypeTransformer knownTypeTransformer = TransformerFactory.getTypeTransformer(string2);
                if (knownTypeTransformer != null) {
                    LinkedList linkedList2 = (LinkedList)map.get("LAST_DECLARED_TEMPLATE_ARGS");
                    knownTypeTransformer.createInstance(string, linkedList, linkedList2, map, tAModel, sCModel);
                } else {
                    Module module = sCModel.getModule(string2);
                    CClass cClass = sCModel.getClass(string2);
                    if (module != null) {
                        ModuleInstance moduleInstance = new ModuleInstance(string, module);
                        sCModel.addInstance(string, moduleInstance);
                        moduleInstance.setArguments(linkedList);
                    } else if (cClass == null) {
                        this.reportError(node, "Unknown type!");
                    }
                }
            }
        } else if (map.containsKey("CURRENT_LOCATION") && map.get("CURRENT_LOCATION").equals((Object)AbstractTransformer.LocationType.METHOD)) {
            TATemplate tATemplate = (TATemplate)map.get("CURRENT_METHOD_TEMPLATE");
            Stack stack = (Stack)map.get("OPERAND_STACK");
            try {
                if (string2 == "int") {
                    int n = Integer.parseInt((String)map.get("LAST_DECLARED_TYPE_LENGTH"));
                    Node node4 = this.findChildNode(node2, "declarator_suffixes");
                    if (node4 != null) {
                        if (n != 0) {
                            int n2 = -(1 << n - 1);
                            int n3 = -n2 - 1;
                            string2 = string2 + "[" + n2 + ", " + n3 + "]";
                        }
                        String string3 = this.getAttributeValue(node4, "arrayCounter");
                        TAArray tAArray = new TAArray(string, string2, string3, true, false);
                        this.handleNode(node4, map, tAModel, sCModel);
                        for (int i = Integer.parseInt(string3) - 1; i >= 0; --i) {
                            try {
                                tAArray.addSizeOfDimension(Integer.parseInt((String)stack.pop()), i);
                                continue;
                            }
                            catch (Exception exception) {
                                this.reportError(node, "Error in array declaration: Dimensions expressions are required and can only be constant expressions.");
                            }
                        }
                        Node node5 = this.findChildNode(node, "initializer");
                        if (node5 != null) {
                            this.handleNode(node5, map, tAModel, sCModel);
                            tAArray.setInitializer((String)stack.pop());
                        }
                        tATemplate.addLocalVar(tAArray);
                    } else {
                        TAInteger tAInteger = new TAInteger(string);
                        if (n != 0) {
                            tAInteger.setBits(n);
                        }
                        tATemplate.addLocalVar(tAInteger);
                        Node node6 = this.findChildNode(node, "initializer");
                        if (node6 != null) {
                            this.handleNode(node6, map, tAModel, sCModel);
                            TALocation tALocation = (TALocation)map.get("CURRENT_METHOD_LOCATION");
                            TALocation tALocation2 = tATemplate.createStandardLocation();
                            TATransition tATransition = new TATransition(tALocation, tALocation2);
                            String string4 = (String)stack.pop();
                            tATransition.addUpdateExpression(new BinaryExpression((Expression)new VariableExpression(tAInteger), string4, "="));
                            tATemplate.addTransition(tATransition);
                            map.put("CURRENT_METHOD_LOCATION", tALocation2);
                        }
                    }
                } else if (sCModel.isKnownType(string2)) {
                    if (sCModel.getSimpleType(string2) != null) {
                        TAInteger tAInteger = new TAInteger(string);
                        tATemplate.addLocalVar(tAInteger);
                    } else {
                        TAStruct tAStruct = new TAStruct("", string, sCModel.getClass(string2));
                        tATemplate.addLocalVar(tAStruct);
                    }
                } else {
                    this.handleNode(this.findChildNode(node, "arguments_list"), map, tAModel, sCModel);
                    stack = (Stack)map.get("OPERAND_STACK");
                    LinkedList<String> linkedList = new LinkedList<String>();
                    LinkedList linkedList3 = (LinkedList)map.get("LAST_DECLARED_TEMPLATE_ARGS");
                    while (stack.size() > 0) {
                        linkedList.addFirst((String)stack.pop());
                    }
                    KnownTypeTransformer knownTypeTransformer = TransformerFactory.getTypeTransformer(string2);
                    if (knownTypeTransformer != null) {
                        knownTypeTransformer.createMethodInstance(string, linkedList, linkedList3, map, tAModel, sCModel);
                    } else {
                        Module module = sCModel.getModule(string2);
                        Module module2 = (Module)map.get("CURRENT_MODULE");
                        if (module != null) {
                            ModuleInstance moduleInstance = new ModuleInstance(string, module);
                            moduleInstance.setArguments(linkedList);
                            module2.addComplexMember(moduleInstance);
                            LinkedList<TAVariable> linkedList4 = moduleInstance.processConstructor();
                            if (linkedList4.size() != 0) {
                                TALocation tALocation = (TALocation)map.get("CURRENT_METHOD_LOCATION");
                                TALocation tALocation3 = tATemplate.createStandardLocation();
                                TATransition tATransition = new TATransition(tALocation, tALocation3);
                                for (TAVariable tAVariable : linkedList4) {
                                    tATransition.addUpdateExpression(new BinaryExpression((Expression)new VariableExpression(tAVariable), ((TAInteger)tAVariable).getInitValue(), "="));
                                }
                                tATemplate.addTransition(tATransition);
                                map.put("CURRENT_METHOD_LOCATION", tALocation3);
                            }
                        } else {
                            CClass cClass = sCModel.getClass(string2);
                            if (cClass == null) {
                                this.reportError(node, "Unknown type!");
                            }
                        }
                    }
                }
            }
            catch (NullPointerException nullPointerException) {
                this.reportError(node, "Variable declaration invalid. Pointers are not supported. ");
            }
        }
    }
}

