/*
 * Decompiled with CFR 0.152.
 */
package de.tub.pes.state.engine;

import de.tub.pes.state.engine.AbstractTransformer;
import de.tub.pes.state.model.SCModel;
import de.tub.pes.state.model.TALocation;
import de.tub.pes.state.model.TAModel;
import de.tub.pes.state.model.TATemplate;
import de.tub.pes.state.model.TATransition;
import de.tub.pes.state.model.expression.ConstantExpression;
import de.tub.pes.state.model.expression.UnaryExpression;
import java.util.Map;
import java.util.Stack;
import org.w3c.dom.Node;

public class ForStatementTransformer
extends AbstractTransformer {
    @Override
    public void transformNode(Node node, Map<String, Object> environment, TAModel ta, SCModel scModel) {
        if (environment.get("CURRENT_LOCATION").equals((Object)AbstractTransformer.LocationType.METHOD)) {
            this.handleNode(this.findChildNode(node, "for_init"), environment, ta, scModel);
            TATemplate template = (TATemplate)environment.get("CURRENT_METHOD_TEMPLATE");
            TALocation startOfFor = (TALocation)environment.get("CURRENT_METHOD_LOCATION");
            TALocation startOfBody = template.createStandardLocation();
            TALocation startOfUpdate = template.createStandardLocation();
            TALocation endOfFor = template.createStandardLocation();
            TALocation oldBefore = (TALocation)environment.get("BEFORE_METHOD_LOCATION");
            TALocation oldAfter = (TALocation)environment.get("AFTER_METHOD_LOCATION");
            String condition = "true";
            Node condNode = this.findChildNode(node, "for_condition");
            if (condNode != null) {
                this.handleNode(condNode, environment, ta, scModel);
                Stack stack = (Stack)environment.get("OPERAND_STACK");
                condition = stack.size() > 0 ? (String)stack.pop() : "true";
            }
            TALocation endOfCondExpr = (TALocation)environment.get("CURRENT_METHOD_LOCATION");
            TATransition blockPath = new TATransition(endOfCondExpr, startOfBody);
            blockPath.setGuard(new ConstantExpression(condition));
            template.addTransition(blockPath);
            environment.put("BEFORE_METHOD_LOCATION", startOfUpdate);
            environment.put("CURRENT_METHOD_LOCATION", startOfBody);
            environment.put("AFTER_METHOD_LOCATION", endOfFor);
            this.handleNode(this.findChildNode(node, "for_block"), environment, ta, scModel);
            TALocation endOfBlock = (TALocation)environment.get("CURRENT_METHOD_LOCATION");
            if (endOfBlock != endOfFor && endOfBlock != startOfUpdate && endOfBlock != template.getInitLocation()) {
                Stack stack = (Stack)environment.get("OPERAND_STACK");
                template.addTransition(new TATransition(endOfBlock, startOfUpdate));
            }
            environment.put("CURRENT_METHOD_LOCATION", startOfUpdate);
            String updateExpr = null;
            Node updateNode = this.findChildNode(node, "for_update");
            if (updateNode != null) {
                this.handleNode(updateNode, environment, ta, scModel);
                Stack mystack = (Stack)environment.get("OPERAND_STACK");
                updateExpr = mystack.size() > 0 ? (String)mystack.pop() : "true";
            }
            TALocation endOfUpdate = (TALocation)environment.get("CURRENT_METHOD_LOCATION");
            TATransition update = new TATransition(endOfUpdate, startOfFor);
            if (updateExpr != null) {
                update.addUpdateExpression(new ConstantExpression(updateExpr));
            }
            template.addTransition(update);
            TATransition exitPath = new TATransition(endOfCondExpr, endOfFor);
            exitPath.setGuard(new UnaryExpression(condition, "!"));
            template.addTransition(exitPath);
            environment.put("BEFORE_METHOD_LOCATION", oldBefore);
            environment.put("CURRENT_METHOD_LOCATION", endOfFor);
            environment.put("AFTER_METHOD_LOCATION", oldAfter);
        }
    }
}

