/*
 * Decompiled with CFR 0.152.
 */
package de.tub.pes.state.engine;

import de.tub.pes.state.engine.Transformer;
import de.tub.pes.state.engine.TransformerFactory;
import de.tub.pes.state.model.Constants;
import de.tub.pes.state.model.SCModel;
import de.tub.pes.state.model.TAModel;
import de.tub.pes.state.optimization.OptimizationEngine;
import de.tub.pes.state.util.CommandLineParser;
import de.tub.pes.state.util.IOUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class Engine {
    private SCModel scModel;
    private TAModel ta = new TAModel();
    private Map<String, Object> environment;

    public Engine() {
        this.scModel = new SCModel();
        this.environment = new HashMap<String, Object>();
        try {
            TransformerFactory.initialize();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private boolean transform(String string, String string2, String string3, String string4, String string5) {
        Document document;
        long l = System.currentTimeMillis();
        HashMap<String, Integer> hashMap = this.readPeqSizeFile(string4);
        this.ta.setPeqSizeMap(hashMap);
        long l2 = System.currentTimeMillis();
        this.scModel.readTB(string3);
        try {
            document = Engine.readXML(string);
        }
        catch (SAXException sAXException) {
            System.out.println("Error parsing input file. No regular XML.");
            sAXException.printStackTrace();
            return false;
        }
        catch (IOException iOException) {
            System.out.println("Can not open input file " + string + ". Check access rights.");
            iOException.printStackTrace();
            return false;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.out.println("Can not create or configure DOM-Parser.");
            parserConfigurationException.printStackTrace();
            return false;
        }
        Constants.createPredefined(this.ta);
        long l3 = System.currentTimeMillis();
        this.parseTree(document);
        long l4 = System.currentTimeMillis();
        this.scModel.completeModules(this.ta);
        this.scModel.create(this.ta);
        int n = this.scModel.countThreads();
        Constants.createScheduler(this.ta, n);
        long l5 = System.currentTimeMillis();
        this.optimize();
        long l6 = System.currentTimeMillis();
        this.ta.labelLocations();
        this.writeOut(string2);
        this.readReplace(string2, "#", "\\$");
        System.out.println("PEQ-File parsing time: " + new Long(l2 - l));
        System.out.println("XML Parse time: " + new Long(l3 - l2).toString());
        System.out.println("Transformation time: " + new Long(l4 - l3).toString());
        System.out.println("Inst./Bind time: " + new Long(l5 - l4).toString());
        System.out.println("Optimization time: " + new Long(l6 - l5).toString());
        return true;
    }

    private HashMap<String, Integer> readPeqSizeFile(String string) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        if (string == null) {
            return hashMap;
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.startsWith("//") || string2.startsWith("#")) continue;
                String[] stringArray = string2.split(" ");
                if (stringArray.length >= 2) {
                    try {
                        hashMap.put(stringArray[0], Integer.parseInt(stringArray[1]));
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Unable to parse line \"" + string2 + "\" from PEQ-File. Ignoring the line.");
                    }
                    continue;
                }
                System.out.println("Incorrect format for line \"" + string2 + "\" from PEQ-File. Ignoring the line.");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("PEQ-File not found at " + string + ". Ignoring the PEQ-File.");
            hashMap.clear();
            return hashMap;
        }
        catch (IOException iOException) {
            System.out.println("Unable to read from PEQ-File " + string + ". Check access rights. Ignoring the PEQ-File.");
            hashMap.clear();
            return hashMap;
        }
        return hashMap;
    }

    public static Document readXML(String string) throws SAXException, IOException, ParserConfigurationException {
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(IOUtil.getInputStream(string));
        return document;
    }

    public void parseTree(Document document) {
        Node node = document.getFirstChild();
        Transformer transformer = TransformerFactory.getTransformer(node);
        transformer.transformNode(node, this.environment, this.ta, this.scModel);
    }

    public void optimize() {
        OptimizationEngine.run(this.ta);
    }

    public void writeOut(String string) {
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(new FileOutputStream(new File(string)));
            if (this.ta != null) {
                this.ta.print(outputStreamWriter);
                outputStreamWriter.flush();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void readReplace(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string4;
            FileInputStream fileInputStream = new FileInputStream(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            while ((string4 = bufferedReader.readLine()) != null) {
                string4 = string4.replaceAll(string2, string3);
                stringBuffer.append(string4 + "\n");
            }
            bufferedReader.close();
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            bufferedWriter.write(stringBuffer.toString());
            bufferedWriter.close();
        }
        catch (Throwable throwable) {
            System.err.println("*** exception ***" + throwable);
        }
    }

    public static void main(String[] stringArray) {
        Engine engine;
        Map<String, String> map = CommandLineParser.parseArgs(stringArray);
        if (map.size() == 0) {
            System.out.println("Insufficent number of parameters. Use -h for help.");
            return;
        }
        if (map.containsKey("h") || map.containsKey("H")) {
            System.out.println("SystemC to Timed Automata Transformation Engine ver. 1.0");
            System.out.println("");
            System.out.println("Mandatory Arguments:");
            System.out.println("-i [INPUTFILE] - absolute path to the AST xml-File which should be transformed");
            System.out.println();
            System.out.println("Optional Arguments:");
            System.out.println("-o [OUTPUTFILE] - absolute path where the resulting UPPAAL-file should be created. (default: inputfilename + .uppaal.xml)");
            System.out.println("-tb [TESTBENCHFILE] - absolute path to the testbench-file");
            System.out.println("-maxpeq [INT] - number of entries per PEQ. (default: 4)");
            System.out.println("-p [PEQFILE] - absolute path to a file containing the sizes for all PEQs. (default: inputfilename + .peq)");
            return;
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n = 4;
        if (!map.containsKey("i")) {
            System.out.println("No input file specified. Use -h for help.");
            return;
        }
        string = map.get("i");
        if (map.containsKey("o")) {
            string2 = map.get("o");
        } else {
            string2 = Engine.createFileName(string, ".uppaal.xml");
            System.out.println("No output file specified. Generating output file name from input file name.");
            System.out.println("Outputfile is " + string2 + ".");
        }
        if (map.containsKey("tb")) {
            string3 = map.get("tb");
        }
        if (map.containsKey("maxpeq")) {
            try {
                n = Integer.parseInt(map.get("maxpeq"));
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Submitted maxpeq-argument is no integer value.");
                return;
            }
            Constants.GLOBAL_PEQ_SIZE = n;
        }
        if (map.containsKey("p")) {
            string4 = map.get("p");
        }
        if (!(engine = new Engine()).transform(string, string2, string3, string4, null)) {
            System.out.println("An error occured during transformation.");
        }
    }

    public static String createFileName(String string, String string2) {
        if (string.matches(".*\\.xml")) {
            string = string.substring(0, string.lastIndexOf("."));
        }
        return string + string2;
    }
}

