/*
 * Decompiled with CFR 0.152.
 */
package de.tub.pes.state.engine;

import de.tub.pes.state.engine.AbstractTransformer;
import de.tub.pes.state.model.SCModel;
import de.tub.pes.state.model.TAModel;
import java.util.Map;
import java.util.Stack;
import org.w3c.dom.Node;

public class BinaryOperatorTransformer
extends AbstractTransformer {
    @Override
    public void transformNode(Node node, Map<String, Object> map, TAModel tAModel, SCModel sCModel) {
        this.handleChildNodes(node, map, tAModel, sCModel);
        Stack stack = (Stack)map.get("OPERAND_STACK");
        if (stack.size() >= 2) {
            String string;
            String string2 = (String)stack.pop();
            String string3 = (String)stack.pop();
            if (string2 == null || string3 == null) {
                this.reportError(node, "Missing argument for binary operation.");
            }
            if ((string = BinaryOperatorTransformer.getOperatorString(node.getNodeName())) == null) {
                this.reportError(node, "Unknown binary operator");
            }
            stack.push("(" + string3 + ") " + string + " (" + string2 + ")");
        } else {
            this.reportError(node, "Missing argument for binary operation.");
        }
    }

    private static String getOperatorString(String string) {
        if (string.equals("add_node")) {
            return "+";
        }
        if (string.equals("subtract_node")) {
            return "-";
        }
        if (string.equals("mul_node")) {
            return "*";
        }
        if (string.equals("div_node")) {
            return "/";
        }
        if (string.equals("mod_node")) {
            return "%";
        }
        if (string.equals("bitwise_and_node")) {
            return "&";
        }
        if (string.equals("bitwise_or_node")) {
            return "|";
        }
        if (string.equals("bitwise_xor_node")) {
            return "^";
        }
        if (string.equals("and_node")) {
            return "&&";
        }
        if (string.equals("or_node")) {
            return "||";
        }
        if (string.equals("eq_node")) {
            return "==";
        }
        if (string.equals("lt_node")) {
            return "<";
        }
        if (string.equals("gt_node")) {
            return ">";
        }
        if (string.equals("le_node")) {
            return "<=";
        }
        if (string.equals("ge_node")) {
            return ">=";
        }
        if (string.equals("neq_node")) {
            return "!=";
        }
        if (string.equals("neq_node")) {
            return "!=";
        }
        if (string.equals("left_shift_node")) {
            return "<<";
        }
        if (string.equals("right_shift_node")) {
            return ">>";
        }
        return null;
    }
}

