/*
 * Decompiled with CFR 0.152.
 */
package de.tub.pes.state.engine;

import de.tub.pes.state.engine.AbstractTransformer;
import de.tub.pes.state.model.CClass;
import de.tub.pes.state.model.Constructor;
import de.tub.pes.state.model.Function;
import de.tub.pes.state.model.Module;
import de.tub.pes.state.model.ModuleInstance;
import de.tub.pes.state.model.SCModel;
import de.tub.pes.state.model.TAArray;
import de.tub.pes.state.model.TAInteger;
import de.tub.pes.state.model.TALocation;
import de.tub.pes.state.model.TAModel;
import de.tub.pes.state.model.TATemplate;
import de.tub.pes.state.model.TATransition;
import de.tub.pes.state.model.TAVariable;
import de.tub.pes.state.model.expression.BinaryExpression;
import de.tub.pes.state.model.expression.Expression;
import de.tub.pes.state.model.expression.VariableExpression;
import java.util.Map;
import java.util.Stack;
import org.w3c.dom.Node;

public class AssignmentTransformer
extends AbstractTransformer {
    @Override
    public void transformNode(Node node, Map<String, Object> map, TAModel tAModel, SCModel sCModel) {
        block26: {
            AbstractTransformer.LocationType locationType = (AbstractTransformer.LocationType)((Object)map.get("CURRENT_LOCATION"));
            Stack stack = (Stack)map.get("OPERAND_STACK");
            boolean bl = false;
            if (locationType.equals((Object)AbstractTransformer.LocationType.METHOD)) {
                Object object;
                this.handleChildNodes(node, map, tAModel, sCModel);
                Node node2 = this.findChildNode(node, "assignment_expression_operator");
                String string = "=";
                if (node2 != null) {
                    string = this.getAttributeValue(node2, "name");
                }
                if (stack.size() < 2) {
                    this.reportError(node, "invalid assignment");
                    return;
                }
                String string2 = (String)stack.pop();
                String string3 = (String)stack.peek();
                if (string2.endsWith("#return")) {
                    bl = true;
                }
                TATemplate tATemplate = (TATemplate)map.get("CURRENT_METHOD_TEMPLATE");
                TAVariable tAVariable = null;
                ModuleInstance moduleInstance = null;
                if (map.get("CURRENT_CLASS") == null) {
                    object = (Module)map.get("CURRENT_MODULE");
                    tAVariable = ((Module)object).getMember(string3);
                    moduleInstance = ((Module)object).getComplexMember(string3);
                } else {
                    object = (CClass)map.get("CURRENT_CLASS");
                    tAVariable = ((CClass)object).getMember(string3);
                }
                object = (TALocation)map.get("CURRENT_METHOD_LOCATION");
                TALocation tALocation = tATemplate.createStandardLocation();
                TATransition tATransition = new TATransition((TALocation)object, tALocation);
                tATemplate.addTransition(tATransition);
                if (tAVariable != null) {
                    tATransition.addUpdateExpression(new BinaryExpression(string3, string2, string));
                    if (bl) {
                        tATransition.addUpdateExpression(new BinaryExpression(string2, "0", "="));
                    }
                } else if (moduleInstance != null) {
                    string3 = string3 + "#";
                    string2 = string2 + "#";
                    for (TAVariable tAVariable2 : moduleInstance.getModule().getElements()) {
                        if (tAVariable2 instanceof TAInteger) {
                            tATransition.addUpdateExpression(new BinaryExpression((Expression)new VariableExpression(tAVariable2.createCopy(string3)), (Expression)new VariableExpression(tAVariable2.createCopy(string2)), string));
                            continue;
                        }
                        if (!(tAVariable2 instanceof TAArray)) continue;
                        this.reportError(node, "Sorry, array copy in complex assignments not implemented yet");
                    }
                } else {
                    tATransition.addUpdateExpression(new BinaryExpression(string3, string2, string));
                    if (bl) {
                        tATransition.addUpdateExpression(new BinaryExpression(string2, "0", "="));
                    }
                }
                map.put("CURRENT_METHOD_LOCATION", tALocation);
            } else if (locationType.equals((Object)AbstractTransformer.LocationType.CTOR)) {
                Object object;
                this.handleChildNodes(node, map, tAModel, sCModel);
                String string = (String)stack.pop();
                String string4 = (String)stack.pop();
                TAVariable tAVariable = null;
                if (map.get("CURRENT_CLASS") == null) {
                    object = (Module)map.get("CURRENT_MODULE");
                    tAVariable = ((Module)object).getMember(string4);
                } else {
                    object = (CClass)map.get("CURRENT_CLASS");
                    tAVariable = ((CClass)object).getMember(string4);
                }
                object = (Constructor)map.get("CURRENT_METHOD");
                if (tAVariable != null) {
                    if (((Function)object).hasParam(string)) {
                        ((Constructor)object).addIniter(string, tAVariable);
                    } else {
                        try {
                            if (string.contains("[^-+\\*/[0-9]\\(\\)")) {
                                this.reportError(node, "Illegal assignment in constructor. Only constant member initializations allowed.");
                                break block26;
                            }
                            ((TAInteger)tAVariable).setInitValue(string);
                        }
                        catch (Exception exception) {
                            System.out.println(string);
                            this.reportError(node, "Illegal assignment in constructor. Only constant member initializations allowed.");
                        }
                    }
                } else if (!string4.contains(".")) {
                    this.reportError(node, "Assignments to variables other than class members are not supported in constructor.");
                }
            }
        }
    }
}

