/*
 * Decompiled with CFR 0.152.
 */
package de.tub.pes.state.engine;

import de.tub.pes.state.engine.Engine;
import de.tub.pes.state.engine.KnownTypeTransformer;
import de.tub.pes.state.engine.Transformer;
import de.tub.pes.state.engine.TransformerFactory;
import de.tub.pes.state.model.Module;
import de.tub.pes.state.model.ModuleInstance;
import de.tub.pes.state.model.SCModel;
import de.tub.pes.state.model.TAInteger;
import de.tub.pes.state.model.TALocation;
import de.tub.pes.state.model.TAModel;
import de.tub.pes.state.model.TATemplate;
import de.tub.pes.state.model.TATransition;
import de.tub.pes.state.model.TAVariable;
import de.tub.pes.state.model.expression.BinaryExpression;
import de.tub.pes.state.model.expression.Expression;
import de.tub.pes.state.model.expression.VariableExpression;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

abstract class AbstractType
implements KnownTypeTransformer {
    protected String name = null;
    protected String impl = null;
    protected boolean created = false;

    AbstractType() {
    }

    @Override
    public void createType(SCModel sCModel, TAModel tAModel) {
        if (this.impl != null && !this.created) {
            try {
                Document document = Engine.readXML(this.impl);
                Node node = document.getFirstChild();
                SCModel sCModel2 = new SCModel();
                Transformer transformer = TransformerFactory.getTransformer(node);
                transformer.transformNode(node, new HashMap<String, Object>(), tAModel, sCModel2);
                HashMap<String, Module> hashMap = sCModel2.getModules();
                if (hashMap.size() == 1) {
                    this.name = (String)hashMap.keySet().iterator().next();
                    if (!sCModel.getModules().containsKey(this.name)) {
                        sCModel.addModule(this.name, (Module)hashMap.get(this.name));
                    }
                } else {
                    System.out.println("Implementation files for known types have to contain exactly one module.");
                }
                this.created = true;
            }
            catch (SAXException sAXException) {
                sAXException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                parserConfigurationException.printStackTrace();
            }
        }
    }

    @Override
    public void createMember(String string, LinkedList<String> linkedList, List<String> list, Map<String, Object> map, TAModel tAModel, SCModel sCModel) {
        Module module = (Module)map.get("CURRENT_MODULE");
        Module module2 = sCModel.getModule(this.name);
        module.addComplexMember(string, module2);
    }

    @Override
    public void createMethodInstance(String string, LinkedList<String> linkedList, List<String> list, Map<String, Object> map, TAModel tAModel, SCModel sCModel) {
        Module module = (Module)map.get("CURRENT_MODULE");
        Module module2 = sCModel.getModule(this.name);
        ModuleInstance moduleInstance = new ModuleInstance(this.name, module2);
        sCModel.addInstance(string, moduleInstance);
        moduleInstance.setArguments(linkedList);
        module.addComplexMember(moduleInstance);
        LinkedList<TAVariable> linkedList2 = moduleInstance.processConstructor();
        if (linkedList2.size() != 0) {
            TATemplate tATemplate = (TATemplate)map.get("CURRENT_METHOD_TEMPLATE");
            TALocation tALocation = (TALocation)map.get("CURRENT_METHOD_LOCATION");
            TALocation tALocation2 = tATemplate.createUrgentLocation();
            TATransition tATransition = new TATransition(tALocation, tALocation2);
            for (TAVariable tAVariable : linkedList2) {
                tATransition.addUpdateExpression(new BinaryExpression((Expression)new VariableExpression(tAVariable), ((TAInteger)tAVariable).getInitValue(), "="));
            }
            tATemplate.addTransition(tATransition);
            map.put("CURRENT_METHOD_LOCATION", tALocation2);
        }
    }

    @Override
    public String getImplementation() {
        return this.impl;
    }

    @Override
    public void setImplementation(String string) {
        this.impl = string;
    }

    @Override
    public void createInstance(String string, LinkedList<String> linkedList, List<String> list, Map<String, Object> map, TAModel tAModel, SCModel sCModel) {
        Module module = sCModel.getModule(this.name);
        if (module != null) {
            ModuleInstance moduleInstance = new ModuleInstance(string, module);
            sCModel.addInstance(string, moduleInstance);
            moduleInstance.setArguments(linkedList);
        }
    }
}

