/*
 * Decompiled with CFR 0.152.
 */
package de.tub.pes.state.engine;

import de.tub.pes.state.engine.Transformer;
import de.tub.pes.state.engine.TransformerFactory;
import de.tub.pes.state.model.SCModel;
import de.tub.pes.state.model.TAModel;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractTransformer
implements Transformer {
    public static final String CURRENT_LOCATION_KEY = "CURRENT_LOCATION";
    public static final String CURRENT_MODULE_KEY = "CURRENT_MODULE";
    public static final String CURRENT_CLASS_KEY = "CURRENT_CLASS";
    public static final String CURRENT_ACCESS_LEVEL_KEY = "CURRENT_ACCESS_LEVEL";
    public static final String CURRENT_METHOD_KEY = "CURRENT_METHOD";
    public static final String CURRENT_METHOD_TEMPLATE_KEY = "CURRENT_METHOD_TEMPLATE";
    public static final String METHOD_TEMPLATE_LOC_BEFORE = "BEFORE_METHOD_LOCATION";
    public static final String METHOD_TEMPLATE_LOC_CURRENT = "CURRENT_METHOD_LOCATION";
    public static final String METHOD_TEMPLATE_LOC_AFTER = "AFTER_METHOD_LOCATION";
    public static final String LAST_DECLARED_TYPE_KEY = "LAST_DECLARED_TYPE";
    public static final String LAST_DECLARED_TYPE_TEMPLATE_ARGS_KEY = "LAST_DECLARED_TEMPLATE_ARGS";
    public static final String LAST_DECLARED_TYPE_LENGTH_KEY = "LAST_DECLARED_TYPE_LENGTH";
    public static final String LAST_DECLARED_THREAD_KEY = "LAST_DECLARED_THREAD";
    public static final String PEQ_MAP_KEY = "PEQ_MAP";
    public static final String IS_PORT_DECLARATION_KEY = "IS_PORT_DECLARATION";
    public static final String IS_SOCKET_DECLARATION_KEY = "IS_SOCKET_DECLARATION";
    public static final String IS_ASSIGNMENT_KEY = "IS_ASSIGNMENT";
    public static final String OPERAND_STACK_KEY = "OPERAND_STACK";
    public static final String DEREFERENCE_STACK_KEY = "DEREFERENCE_STACK";
    public static final String STOP_EVALUATING_SIBLINGS_KEY = "STOP_SIBLINGS_EVAL";

    protected void handleNode(Node node, Map<String, Object> map, TAModel tAModel, SCModel sCModel) {
        if (node != null) {
            Transformer transformer = TransformerFactory.getTransformer(node);
            transformer.transformNode(node, map, tAModel, sCModel);
        }
    }

    protected void handleChildNodes(Node node, Map<String, Object> map, TAModel tAModel, SCModel sCModel) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            Transformer transformer = TransformerFactory.getTransformer(node2);
            transformer.transformNode(node2, map, tAModel, sCModel);
        }
    }

    protected String getAttributeValue(Node node, String string) {
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 == null) {
            return null;
        }
        return node2.getNodeValue();
    }

    protected Node findChildNode(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals(string)) continue;
            return node2;
        }
        return null;
    }

    protected Node findFirstChildNot(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeName().equals(string) || node2.getNodeName().equals("#text")) continue;
            return node2;
        }
        return null;
    }

    protected List<Node> findChildNodes(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        LinkedList<Node> linkedList = new LinkedList<Node>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals(string)) continue;
            linkedList.addLast(node2);
        }
        return linkedList;
    }

    protected List<Node> findRealChildNodes(Node node) {
        NodeList nodeList = node.getChildNodes();
        LinkedList<Node> linkedList = new LinkedList<Node>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeName().equals("#text")) continue;
            linkedList.addLast(node2);
        }
        return linkedList;
    }

    protected Node findFirstRealChild(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeName().equals("#text")) continue;
            return node2;
        }
        return null;
    }

    protected void reportError(Node node, String string) {
        System.out.println(this.getAttributeValue(node, "file") + ": " + this.getAttributeValue(node, "line") + ": " + this.getClass() + ": " + string);
    }

    protected String createPrefix(Stack<String> stack) {
        String string = "";
        if (stack == null) {
            return string;
        }
        for (int i = 0; i < stack.size(); ++i) {
            string = string + (String)stack.get(i) + "#";
        }
        return string;
    }

    public static enum LocationType {
        TOP,
        CLASS,
        METHOD,
        CTOR,
        MAIN;

    }
}

