clear all
close all
%-------------------
% Solution of Boundary Value Problem with the shooting method.
% Equation to solve:
% y''+lambda*y=0 
% the interval [0,1] 
% Boundary conditions are: y(0)=y(1)=0
%--------------------
global a b b1 b2 h
 a=0;
 b=1;
 x10=0;
 x20=pi;
 h=0.025;
 s10=100; % 0.5; 50; 100
 b1=0;
 ds=0.01;
 s(1)=s10;
 K=450;
 delta=0.001;
 %----------------
 s(1)=0.5;
 for i=1:K
R=rk4s3('qe1','qe2','qe3',a,b,x10,x20,s(i),h);
f(i)=[R(size(R,1),2)-b1];
R1=rk4s3('qe1','qe2','qe3',a,b,x10,x20,s(i)+ds,h);
f1(i)=[R1(size(R1,1),2)-b1];
s(i+1)=s(i)-(f(i)*ds)/(f1(i)-f(i));
 if (abs(s(:,i+1)-s(:,i))<delta)
       break
    end;
 end;
sr=s(size(s,2));
Rend=rk4s3('qe1','qe2','qe3',a,b,x10,x20,sr,h);
plot(Rend(:,1),Rend(:,2),'r','Linewidth',2)
hold on
%----------------
 s1(1)=50;
 for i=1:K
R1=rk4s3('qe1','qe2','qe3',a,b,x10,x20,s1(i),h);
f(i)=[R1(size(R1,1),2)-b1];
R1=rk4s3('qe1','qe2','qe3',a,b,x10,x20,s1(i)+ds,h);
f1(i)=[R1(size(R1,1),2)-b1];
s1(i+1)=s1(i)-(f(i)*ds)/(f1(i)-f(i));
 if (abs(s1(:,i+1)-s1(:,i))<delta)
       break
    end;
 end;
sr1=s1(size(s1,2));
Rend1=rk4s3('qe1','qe2','qe3',a,b,x10,x20,sr1,h);
plot(Rend1(:,1),Rend1(:,2),'b','Linewidth',2)
hold on
%----------------
 s2(1)=100;
 for i=1:K
R2=rk4s3('qe1','qe2','qe3',a,b,x10,x20,s2(i),h);
f(i)=[R2(size(R2,1),2)-b1];
R2=rk4s3('qe1','qe2','qe3',a,b,x10,x20,s2(i)+ds,h);
f1(i)=[R2(size(R2,1),2)-b1];
s2(i+1)=s2(i)-(f(i)*ds)/(f1(i)-f(i));
 if (abs(s2(:,i+1)-s2(:,i))<delta)
       break
    end;
 end;
sr2=s2(size(s2,2));
Rend2=rk4s3('qe1','qe2','qe3',a,b,x10,x20,sr2,h);
plot(Rend2(:,1),Rend2(:,2),'g','Linewidth',2)
hold on
legend('\lambda=0.5','\lambda=50','\lambda=100')
 xlabel('t','FontName','Times New Roman','FontSize',16)
 ylabel('x','FontName','Times New Roman','FontSize',16)
 
%  tt=0:0.01:1;
%  yy=sin(pi/2*tt)
%  figure(2)
%  plot(Rend(:,1),Rend(:,2),'r','Linewidth',2)
%  hold on
%  plot(tt,yy,'b')