function R=rk4s3(f1,f2,f3,a,b,x10,x20,x30,h)
%----------------------------------------------
%Runge-Kutta Method of Order 4.
% Approximation of the solution of the IVP for the system of two ODE 
% xi'(t)=fi(t,x1(t),x2(t),x3(t),x4(t)),i=1,2,3
% with xi(a)=xi0 over [a,b] by using the formula
% xi(n+1)=xi(n)+h*(ki1+2ki2+2ki3+ki4)/6;
% 
%----------------------------------------------

%----------------------------------------------
M=(b-a)/h;
T=zeros(1,M+1);
X1=zeros(1,M+1);
X2=zeros(1,M+1);
X3=zeros(1,M+1);

T=a:h:b;
X1(1)=x10;
X2(1)=x20;
X3(1)=x30;


for j=1:M
    k11=feval(f1,T(j),X1(j),X2(j),X3(j));
    k12=feval(f2,T(j),X1(j),X2(j),X3(j));
    k13=feval(f3,T(j),X1(j),X2(j),X3(j));
    
    k21=feval(f1,T(j)+h/2,X1(j)+h*k11/2,X2(j)+h*k12/2,X3(j)+h*k13/2);
    k22=feval(f2,T(j)+h/2,X1(j)+h*k11/2,X2(j)+h*k12/2,X3(j)+h*k13/2);
    k23=feval(f3,T(j)+h/2,X1(j)+h*k11/2,X2(j)+h*k12/2,X3(j)+h*k13/2);
    
    k31=feval(f1,T(j)+h/2,X1(j)+h*k21/2,X2(j)+h*k22/2,X3(j)+h*k23/2);
    k32=feval(f2,T(j)+h/2,X1(j)+h*k21/2,X2(j)+h*k22/2,X3(j)+h*k23/2);
    k33=feval(f3,T(j)+h/2,X1(j)+h*k21/2,X2(j)+h*k22/2,X3(j)+h*k23/2);
    
    k41=feval(f1,T(j)+h,X1(j)+h*k31,X2(j)+h*k32,X3(j)+h*k33);
    k42=feval(f2,T(j)+h,X1(j)+h*k31,X2(j)+h*k32,X3(j)+h*k33);
    k43=feval(f3,T(j)+h,X1(j)+h*k31,X2(j)+h*k32,X3(j)+h*k33);
    
   X1(j+1)=X1(j)+h*(k11+2*k21+2*k31+k41)/6;
   X2(j+1)=X2(j)+h*(k12+2*k22+2*k32+k42)/6;
   X3(j+1)=X3(j)+h*(k13+2*k23+2*k33+k43)/6;

end;
R=[T',X1',X2',X3'];