%------------------------------
% Solve a linear BVP
% 
% -x''(t)-(1+t^2)x(t)=1,    -1<t<1
%
% x(-1)=x(1)=0
%
% with the finite difference method.
%
%-----------------------------
clear all
close all
L=1;
M=200;
h=2*L/M; % time step
t=-L:h:L;
x(1)=0;
x(M+1)=0;
%---------------Ax=b-----------------------
 ah=-(2-h^2*(t(2:M).^2+1))';
 au=ones(M-2,1);
 A=diag(ah)+diag(au,1)+diag(au,-1);
 b=-h^2*ones(M-1,1);
 x(2:M)=inv(A)*b;
 plot(t,x,'r','Linewidth',2)
 xlabel('t','FontName','Times New Roman','FontSize',16)
 ylabel('x','FontName','Times New Roman','FontSize',16)