clear all
close all
%-------------------
% Solution of Boundary Value Problem with the linear shooting method.
% Equation to solve:
% x''=(2t/1+t^2)*x'-(2/1+t^2)*x+1
% the interval [0,4] 
% Boundary conditions are: x(0)=1.25; x(4)=-0.95;
%--------------------const--------------------------------
a=0;
b=4;
b1=1.25;
b2=-0.95;
h=0.01; % time step for RK4
%--------------------2 IVP with RK4-------------------------

u=rk4s('ls1','ls2',a,b,b1,0,h);

v=rk4s('ls1','ls3',a,b,0,1,h);

%----------------------x=u+c*v-----------------------------
c=(b2-u(size(u,1),2))/v(size(v,1),2);
x=u(:,2)+c*v(:,2);
%---------------------plot results-------------------------
plot(u(:,1),u(:,2),'r--','Linewidth',2)
hold on
plot(v(:,1),v(:,2),'r','Linewidth',2)
hold on
plot(u(:,1),x,'b','Linewidth',2);
legend('u(t)','v(t)','x(t)')
xlabel('t','FontName','Times New Roman','FontSize',16)
ylabel('u,v,x','FontName','Times New Roman','FontSize',16)
%----------------------------------------------------------