function R=rk4s(f,g,t0,Tend,x0,y0,h)
%----------------------------------------------
%Runge-Kutta Method of Order 4.
% Approximation of the solution of the IVP for the system of two ODE 
% x'(t)=f(t,x(t),y(t)) and y'(t)=g(t,x(t),y(t))
% with x(a)=x0 and y(a)=y0 over [t0,Tend] by using the formula
% x(n+1)=x(n)+h*(k1+2k2+2k3+k4)/6;
% y(n+1)=y(n)+h*(c1+2c2+2c3+c4)/6;
%----------------------------------------------
% Input- f and g  are the functions entered as strings 'f' and 'g';
%          -t0 and Tend are the left and right end time points;
%          - x0 and y0 are initial conditions;
%          - M is the number of steps;
% Output-R=[T', X', Y'], where T is the time vector, X,Y are the position vectors.
%----------------------------------------------
M=(Tend-t0)/h;
T=zeros(1,M+1);
X=zeros(1,M+1);
Y=zeros(1,M+1);
T=t0:h:Tend;
X(1)=x0;
Y(1)=y0;
for j=1:M
    k1=feval(f,T(j),X(j),Y(j));
    c1=feval(g,T(j),X(j),Y(j));
    k2=feval(f,T(j)+h/2,X(j)+h*k1/2,Y(j)+h*c1/2);
    c2=feval(g,T(j)+h/2,X(j)+h*k1/2,Y(j)+h*c1/2);
    k3=feval(f,T(j)+h/2,X(j)+h*k2/2,Y(j)+h*c2/2);
    c3=feval(g,T(j)+h/2,X(j)+h*k2/2,Y(j)+h*c2/2);
    k4=feval(f,T(j)+h,X(j)+h*k3,Y(j)+h*c3);
    c4=feval(g,T(j)+h,X(j)+h*k3,Y(j)+h*c3);
    X(j+1)=X(j)+h*(k1+2*k2+2*k3+k4)/6;
    Y(j+1)=Y(j)+h*(c1+2*c2+2*c3+c4)/6;
end;
R=[T',X',Y'];