%  Zettel2
%%------------------------------------------------------
% Aufgabe 1
% Zu lösen ist 
%
% (1)      d^2x/dt^2+w^2x=0, x(0)=x_0, dx/xt(0)=v0, 0<t<20*pi
%
% mit Hilfe  von
%
% a) Euler-Verfahren 
%  x_{n+1}=x_n+h*f(t_n,x_n)
% 
% b) Heun Verfahren
%
% 
%
% Die Schrittweite h=0.05
% Gl. (1) <=>
%  (2)    dx/dt=y, dy/dt=-w^2*x, x(0)=0, y(0)=v0
% Wir betrachten den Fall w=1; v0=1.
% ----------------------------------------------------------
clear all
close all
 x0=0;
 y0=1;
 t=0;
 Tend=20*pi;
 h=0.05;
 %----------------------------
 ForEuler13(h,t,x0,y0,Tend) % Forward Euler Methode
 hold on
 Trapez(h,t,x0,y0,Tend) % Heun Methode
 hold on
% plot the exact solution x(t)
tr=0:0.1:20*pi;
xr=sin(tr);
plot(tr,xr,'-k','LineWidth',1)
xlabel('t','FontName','Times New Roman','FontSize',16)
ylabel('x','FontName','Times New Roman','FontSize',16)
