%  Zettel1
%%------------------------------------------------------
% Aufgabe 3
% Zu lösen ist 
%
% (1)      d^2x/dt^2+w^2x=0, x(0)=x_0, dx/xt(0)=v0, 0<t<20*pi
%
% mit Hilfe 
%
% von  Euler-Verfahren 
%  x_{n+1}=x_n+h*f(t_n,x_n)
%
% Die Schrittweiten h={0.05, 0.025, 0.001}
% Gl. (1) <=>
%  (2)    dx/dt=y, dy/dt=-w^2*x, x(0)=0, y(0)=v0
% Wir betrachten den Fall w=1; v0=1.
% ----------------------------------------------------------
clear all
close all
 x0=0;
 y0=1;
 t=0;
 Tend=20*pi;
 ForEuler3(0.05,t,x0,y0,Tend)
 hold on
 ForEuler3(0.025,t,x0,y0,Tend)
 hold on
  ForEuler3(0.001,t,x0,y0,Tend)
 hold on
% plot the exact solution x(t)
tr=0:0.1:20*pi;
xr=sin(tr);
plot(tr,xr,'-r')
xlabel('t','FontName','Times New Roman','FontSize',16)
ylabel('x','FontName','Times New Roman','FontSize',16)
