% Funktion Trapez
%%------------------------------------------------------
% Aufgabe 1
% Zu lösen ist 
%
% (1)      d^2x/dt^2+w^2x=0, x(0)=x_0, dx/xt(0)=v0, 0<t<20*pi
%
% mit Hilfe 
%
% von  Heun-Verfahren.
%  
% Gl. (1) <=>
%  (2)    dx/dt=y, dy/dt=-w^2*x, x(0)=0, y(0)=v0
%

function Trapez(h,t,x,y,Tend)
N=Tend/h;

for i=1:(N-1)
c1=h*y;
d1=h*(-x);
c2=h*(y-h*x);
d2=-h*(x+h*y);
x=x+(c1+c2)/2;
y=y+(d1+d2)/2;
t=t+h;
plot(t,x,'ro','LineWidth',1,'MarkerSize',1.8)
 hold on
end

